/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import java.util.EnumSet;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.recalibration.StandardCovariate;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.NGSPlatform;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class CycleCovariate
implements StandardCovariate {
    private static final EnumSet<NGSPlatform> DISCRETE_CYCLE_PLATFORMS = EnumSet.of(NGSPlatform.ILLUMINA, NGSPlatform.SOLID, NGSPlatform.PACBIO, NGSPlatform.COMPLETE_GENOMICS);
    private static final EnumSet<NGSPlatform> FLOW_CYCLE_PLATFORMS = EnumSet.of(NGSPlatform.LS454, NGSPlatform.ION_TORRENT);

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        if (!(RAC.DEFAULT_PLATFORM == null || RAC.DEFAULT_PLATFORM.equalsIgnoreCase("SLX") || RAC.DEFAULT_PLATFORM.equalsIgnoreCase("ILLUMINA") || RAC.DEFAULT_PLATFORM.contains("454") || RAC.DEFAULT_PLATFORM.equalsIgnoreCase("SOLID") || RAC.DEFAULT_PLATFORM.equalsIgnoreCase("ABI_SOLID"))) {
            throw new UserException.CommandLineException("The requested default platform (" + RAC.DEFAULT_PLATFORM + ") is not a recognized platform. Implemented options are illumina, 454, and solid");
        }
    }

    @Override
    public void getValues(GATKSAMRecord read, Comparable[] comparable) {
        NGSPlatform ngsPlatform = read.getNGSPlatform();
        if (DISCRETE_CYCLE_PLATFORMS.contains((Object)ngsPlatform)) {
            int increment;
            int init;
            if (!read.getReadNegativeStrandFlag()) {
                if (read.getReadPairedFlag() && read.getSecondOfPairFlag()) {
                    init = -1;
                    increment = -1;
                } else {
                    init = 1;
                    increment = 1;
                }
            } else if (read.getReadPairedFlag() && read.getSecondOfPairFlag()) {
                init = -read.getReadLength();
                increment = 1;
            } else {
                init = read.getReadLength();
                increment = -1;
            }
            int cycle = init;
            for (int i = 0; i < read.getReadLength(); ++i) {
                comparable[i] = Integer.valueOf(cycle);
                cycle += increment;
            }
        } else if (FLOW_CYCLE_PLATFORMS.contains((Object)ngsPlatform)) {
            int cycle;
            int readLength = read.getReadLength();
            byte[] bases = read.getReadBases();
            boolean multiplyByNegative1 = read.getReadPairedFlag() && read.getSecondOfPairFlag();
            int n = cycle = multiplyByNegative1 ? -1 : 1;
            if (!read.getReadNegativeStrandFlag()) {
                int iii = 0;
                while (iii < readLength) {
                    while (iii < readLength && bases[iii] == 84) {
                        comparable[iii] = Integer.valueOf(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 65) {
                        comparable[iii] = Integer.valueOf(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 67) {
                        comparable[iii] = Integer.valueOf(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 71) {
                        comparable[iii] = Integer.valueOf(cycle);
                        ++iii;
                    }
                    if (iii < readLength) {
                        cycle = multiplyByNegative1 ? --cycle : ++cycle;
                    }
                    if (iii >= readLength || BaseUtils.isRegularBase(bases[iii])) continue;
                    comparable[iii] = Integer.valueOf(cycle);
                    ++iii;
                }
            } else {
                int iii = readLength - 1;
                while (iii >= 0) {
                    while (iii >= 0 && bases[iii] == 84) {
                        comparable[iii] = Integer.valueOf(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 65) {
                        comparable[iii] = Integer.valueOf(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 67) {
                        comparable[iii] = Integer.valueOf(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 71) {
                        comparable[iii] = Integer.valueOf(cycle);
                        --iii;
                    }
                    if (iii >= 0) {
                        cycle = multiplyByNegative1 ? --cycle : ++cycle;
                    }
                    if (iii < 0 || BaseUtils.isRegularBase(bases[iii])) continue;
                    comparable[iii] = Integer.valueOf(cycle);
                    --iii;
                }
            }
        } else {
            throw new UserException("The platform (" + read.getReadGroup().getPlatform() + ") associated with read group " + read.getReadGroup() + " is not a recognized platform. Implemented options are e.g. illumina, 454, and solid");
        }
    }

    @Override
    public final Comparable getValue(String str) {
        return Integer.valueOf(Integer.parseInt(str));
    }
}

