/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;

public class BaseUtils {
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;
    public static final byte N = 78;
    public static final byte D = 68;
    public static final byte[] BASES = new byte[]{65, 67, 71, 84};
    public static final byte[] EXTENDED_BASES = new byte[]{65, 67, 71, 84, 78, 68};
    public static final byte DELETION_INDEX = 4;
    public static final byte NO_CALL_INDEX = 5;
    public static int gIndex = BaseUtils.simpleBaseToBaseIndex((byte)71);
    public static int cIndex = BaseUtils.simpleBaseToBaseIndex((byte)67);
    public static int aIndex = BaseUtils.simpleBaseToBaseIndex((byte)65);
    public static int tIndex = BaseUtils.simpleBaseToBaseIndex((byte)84);

    public static BaseSubstitutionType SNPSubstitutionType(byte base1, byte base2) {
        BaseSubstitutionType t = BaseUtils.isTransition(base1, base2) ? BaseSubstitutionType.TRANSITION : BaseSubstitutionType.TRANSVERSION;
        return t;
    }

    public static boolean isTransition(byte base1, byte base2) {
        int b1 = BaseUtils.simpleBaseToBaseIndex(base1);
        int b2 = BaseUtils.simpleBaseToBaseIndex(base2);
        return b1 == 0 && b2 == 2 || b1 == 2 && b2 == 0 || b1 == 1 && b2 == 3 || b1 == 3 && b2 == 1;
    }

    public static boolean isTransversion(byte base1, byte base2) {
        return !BaseUtils.isTransition(base1, base2);
    }

    private BaseUtils() {
    }

    public static boolean basesAreEqual(byte base1, byte base2) {
        return BaseUtils.simpleBaseToBaseIndex(base1) == BaseUtils.simpleBaseToBaseIndex(base2);
    }

    public static boolean extendedBasesAreEqual(byte base1, byte base2) {
        return BaseUtils.extendedBaseToBaseIndex(base1) == BaseUtils.extendedBaseToBaseIndex(base2);
    }

    @Deprecated
    public static char[] iupacToBases(char code) {
        char[] bases = new char[2];
        switch (code) {
            case '*': 
            case 'A': 
            case 'a': {
                bases[1] = 65;
                bases[0] = 65;
                break;
            }
            case 'C': 
            case 'c': {
                bases[1] = 67;
                bases[0] = 67;
                break;
            }
            case 'G': 
            case 'g': {
                bases[1] = 71;
                bases[0] = 71;
                break;
            }
            case 'T': 
            case 't': {
                bases[1] = 84;
                bases[0] = 84;
                break;
            }
            case 'R': 
            case 'r': {
                bases[0] = 65;
                bases[1] = 71;
                break;
            }
            case 'Y': 
            case 'y': {
                bases[0] = 67;
                bases[1] = 84;
                break;
            }
            case 'S': 
            case 's': {
                bases[0] = 71;
                bases[1] = 67;
                break;
            }
            case 'W': 
            case 'w': {
                bases[0] = 65;
                bases[1] = 84;
                break;
            }
            case 'K': 
            case 'k': {
                bases[0] = 71;
                bases[1] = 84;
                break;
            }
            case 'M': 
            case 'm': {
                bases[0] = 65;
                bases[1] = 67;
                break;
            }
            default: {
                bases[1] = 78;
                bases[0] = 78;
            }
        }
        return bases;
    }

    public static int simpleBaseToBaseIndex(byte base) {
        switch (base) {
            case 42: 
            case 65: 
            case 97: {
                return 0;
            }
            case 67: 
            case 99: {
                return 1;
            }
            case 71: 
            case 103: {
                return 2;
            }
            case 84: 
            case 116: {
                return 3;
            }
        }
        return -1;
    }

    @Deprecated
    public static int simpleBaseToBaseIndex(char base) {
        switch (base) {
            case '*': 
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'G': 
            case 'g': {
                return 2;
            }
            case 'T': 
            case 't': {
                return 3;
            }
        }
        return -1;
    }

    public static int extendedBaseToBaseIndex(byte base) {
        switch (base) {
            case 68: 
            case 100: {
                return 4;
            }
            case 78: 
            case 110: {
                return 5;
            }
        }
        return BaseUtils.simpleBaseToBaseIndex(base);
    }

    @Deprecated
    public static boolean isRegularBase(char base) {
        return BaseUtils.simpleBaseToBaseIndex(base) != -1;
    }

    public static boolean isRegularBase(byte base) {
        return BaseUtils.simpleBaseToBaseIndex(base) != -1;
    }

    public static boolean isNBase(byte base) {
        return base == 78 || base == 110;
    }

    public static byte baseIndexToSimpleBase(int baseIndex) {
        switch (baseIndex) {
            case 0: {
                return 65;
            }
            case 1: {
                return 67;
            }
            case 2: {
                return 71;
            }
            case 3: {
                return 84;
            }
        }
        return 46;
    }

    @Deprecated
    public static char baseIndexToSimpleBaseAsChar(int baseIndex) {
        return (char)BaseUtils.baseIndexToSimpleBase(baseIndex);
    }

    public static int crossTalkPartnerIndex(int baseIndex) {
        switch (baseIndex) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    @Deprecated
    public static char crossTalkPartnerBase(char base) {
        return (char)BaseUtils.baseIndexToSimpleBase(BaseUtils.crossTalkPartnerIndex(BaseUtils.simpleBaseToBaseIndex(base)));
    }

    public static byte complementIndex(int baseIndex) {
        switch (baseIndex) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    public static byte simpleComplement(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 84;
            }
            case 67: 
            case 99: {
                return 71;
            }
            case 71: 
            case 103: {
                return 67;
            }
            case 84: 
            case 116: {
                return 65;
            }
        }
        return base;
    }

    @Deprecated
    public static char simpleComplement(char base) {
        return (char)BaseUtils.simpleComplement((byte)base);
    }

    public static byte[] simpleReverseComplement(byte[] bases) {
        byte[] rcbases = new byte[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = BaseUtils.simpleComplement(bases[bases.length - 1 - i]);
        }
        return rcbases;
    }

    public static byte[] simpleComplement(byte[] bases) {
        byte[] rcbases = new byte[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = BaseUtils.simpleComplement(bases[i]);
        }
        return rcbases;
    }

    @Deprecated
    public static char[] simpleReverseComplement(char[] bases) {
        char[] rcbases = new char[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = BaseUtils.simpleComplement(bases[bases.length - 1 - i]);
        }
        return rcbases;
    }

    @Deprecated
    public static char[] simpleComplement(char[] bases) {
        char[] rcbases = new char[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = BaseUtils.simpleComplement(bases[i]);
        }
        return rcbases;
    }

    @Deprecated
    public static String simpleReverseComplement(String bases) {
        return new String(BaseUtils.simpleReverseComplement(bases.getBytes()));
    }

    @Deprecated
    public static String simpleComplement(String bases) {
        return new String(BaseUtils.simpleComplement(bases.getBytes()));
    }

    public static int mostFrequentBaseIndex(int[] baseCounts) {
        int mostFrequentBaseIndex = 0;
        for (int baseIndex = 1; baseIndex < 4; ++baseIndex) {
            if (baseCounts[baseIndex] <= baseCounts[mostFrequentBaseIndex]) continue;
            mostFrequentBaseIndex = baseIndex;
        }
        return mostFrequentBaseIndex;
    }

    public static int mostFrequentBaseIndexNotRef(int[] baseCounts, int refBaseIndex) {
        int tmp = baseCounts[refBaseIndex];
        baseCounts[refBaseIndex] = -1;
        int result = BaseUtils.mostFrequentBaseIndex(baseCounts);
        baseCounts[refBaseIndex] = tmp;
        return result;
    }

    public static int mostFrequentBaseIndexNotRef(int[] baseCounts, byte refSimpleBase) {
        return BaseUtils.mostFrequentBaseIndexNotRef(baseCounts, BaseUtils.simpleBaseToBaseIndex(refSimpleBase));
    }

    public static byte mostFrequentSimpleBase(int[] baseCounts) {
        return BaseUtils.baseIndexToSimpleBase(BaseUtils.mostFrequentBaseIndex(baseCounts));
    }

    public static double mostFrequentBaseFraction(byte[] sequence) {
        int[] baseCounts = new int[4];
        for (byte base : sequence) {
            int baseIndex = BaseUtils.simpleBaseToBaseIndex(base);
            if (baseIndex < 0) continue;
            int n = baseIndex;
            baseCounts[n] = baseCounts[n] + 1;
        }
        int mostFrequentBaseIndex = BaseUtils.mostFrequentBaseIndex(baseCounts);
        return (double)baseCounts[mostFrequentBaseIndex] / (double)sequence.length;
    }

    public static int getRandomBaseIndex() {
        return BaseUtils.getRandomBaseIndex(-1);
    }

    public static int getRandomBaseIndex(int excludeBaseIndex) {
        int randomBaseIndex = excludeBaseIndex;
        while (randomBaseIndex == excludeBaseIndex) {
            randomBaseIndex = GenomeAnalysisEngine.getRandomGenerator().nextInt(4);
        }
        return randomBaseIndex;
    }

    @Deprecated
    public static byte getRandomBase() {
        return BaseUtils.getRandomBase('.');
    }

    @Deprecated
    public static byte getRandomBase(char excludeBase) {
        return BaseUtils.baseIndexToSimpleBase(BaseUtils.getRandomBaseIndex(BaseUtils.simpleBaseToBaseIndex(excludeBase)));
    }

    public static int sequencePeriod(byte[] seq, int minPeriod) {
        int period;
        for (int pos = period = minPeriod > seq.length ? seq.length : minPeriod; pos < seq.length; ++pos) {
            int offset = pos % period;
            if (Character.toUpperCase(seq[pos]) == Character.toUpperCase(seq[offset])) continue;
            period = offset == 0 ? pos + 1 : pos--;
        }
        return period;
    }

    public static enum BaseSubstitutionType {
        TRANSITION,
        TRANSVERSION;

    }

    public static enum Base {
        A('A', 0),
        C('C', 1),
        G('G', 2),
        T('T', 3);

        byte b;
        int index;

        private Base(char base, int index) {
            this.b = (byte)base;
            this.index = index;
        }

        public byte getBase() {
            return this.b;
        }

        public char getBaseAsChar() {
            return (char)this.b;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean sameBase(byte o) {
            return this.b == o;
        }

        public boolean sameBase(char o) {
            return this.b == (byte)o;
        }

        public boolean sameBase(int i) {
            return this.index == i;
        }
    }
}

