# Filename: MappingConverter.py
# Author: Shuai Yuan
# Version: 05/27/2012
#
# This script is a wrapper for MappingConvertor
#
# MappingConvertor is launched based on these inputs:
#  -i		input intermediate SAM file
#  -m		dipmap file generated with diploid reference genome
#  -o		output final SAM file

import sys
import os
import re
import string
import commands
from tempfile import NamedTemporaryFile

# This function is exceedingly useful, perhaps package for reuse?
def getopts(argv):
    opts = {}
    while argv:
	if argv[0][0] == '-':
	    opts[argv[0]] = argv[1]
	    argv = argv[2:]
	else:
	    argv = argv[1:]
    return opts

def main():
    args = sys.argv[1:]

    try:
	opts = getopts(args)
    except IndexError:
	print "Usage:"
	return 0

    hg19di = opts.get("-m")
    if hg19di == None:
        print "No dipmap file specified."
        return -1
    
    samfile = opts.get("-i")
    if samfile == None:
        print "No SAM file specified."
        return -2

    outputfile = opts.get("-o")
    if outputfile == None:
        print "No output file specified."
        return -6
 

# All inputs have been specified at this point, now validate.
	
    #generate command
    commandline = "MappingConvertor -i %s -m %s.dipmap -o %s " % (samfile, hg19di, outputfile)
    #run
    errorcode, stdout = commands.getstatusoutput(commandline)
    
    #return error code
    return errorcode

if __name__ == "__main__":
    main()
