#!/usr/bin/perl -w
use strict;
use Getopt::Long;

my %opt;


GetOptions(\%opt, "f=s", "b=s", "out=s", "output_path=s","id=s","m=i", "file_type=s", "both", "r=s", "version", "i");

my $cmnd;

if (exists $opt{version}){
	$cmnd = "python /usr/local/bin/pyBarcodeFilter.py --version";
}
else{
	$cmnd = "python /usr/local/bin/pyBarcodeFilter.py -f $opt{f} -b $opt{b} -m $opt{m} --file_type $opt{file_type}";

	if(defined $opt{r}){

	$cmnd.= " -r $opt{r}";

		if(exists $opt{both}){
			$cmnd .= " --both";
		}
	}

	if(exists $opt{i}){
		$cmnd .= " -i";
	}
}

# Create the output directory (for the multiple output files)
my $output_path = $opt{output_path};

system $cmnd;

open(BC,$opt{b}) || die "Cannot open barcode file";
my %bc;
while(my $line = <BC>){
	chomp($line);
	my ($barcode,$sample) = (split(/\t/,$line))[0,1];
	$bc{$barcode}=$sample;
}

system "mv barcode_statistics.txt $opt{out}";

my $ft = lc($opt{file_type});

foreach my $key(keys %bc){
	my @split = (split(/\//,$opt{f}));
	my $l = @split;
	my $output = $split[$l-1];
	$output = (split(/\./,$output))[0];
	$output = "$output"."_"."$key"."_"."$bc{$key}"."."."$ft";
	my $rename = "$output_path/primary_$opt{id}_$bc{$key}-1"."_visible_"."$ft";
	system "mv $output $rename"; 

	if(defined $opt{r}){
		my @split2 = (split(/\//,$opt{r}));
		$l = @split2;
		$output = $split2[$l-1];
		$output = (split(/\./,$output))[0];
		$output = "$output"."_"."$key"."_"."$bc{$key}"."."."$ft";
		$rename = "$output_path/primary_$opt{id}_$bc{$key}-2"."_visible_"."$ft";
		system "mv $output $rename"; 
	}
}


close BC;

