#!/usr/bin/perl -w
use strict;
use Getopt::Long;

my %opt;


GetOptions(\%opt, "f=s","file_type=s","version","gtf=s","align_quality=i","align_score=i","range=i","length=i","max=i","distance=i","ignorestrand","overlap=i","unique","blocks","mutations=s","countoutput=s","stats=s","hittable=s","intronUTRoverlap=s","discarded=s","options","alignOpt","id=s");

my $cmnd;
my $prefix = "rc_$opt{id}";


if (exists $opt{version}){
	$cmnd = "python /usr/local/bin/pyReadCounters.py --version";
}
else{
	$cmnd = "python /usr/local/bin/pyReadCounters.py -f $opt{f} --file_type $opt{file_type} --gtf $opt{gtf} -o $prefix";

	if(exists $opt{options}){

	    $cmnd .= " --range=$opt{range} --overlap=$opt{overlap}";

	    if(exists $opt{ignorestrand}){ $cmnd .= " --ignorestrand";}
	}

	if(exists $opt{alignOpt}){
	    $cmnd .= " --align_quality=$opt{align_quality} --align_score=$opt{align_score} --length=$opt{length} --distance=$opt{distance}";
            if(exists $opt{max}){$cmnd .= " --max=$opt{max}";}
	    if(exists $opt{unique}){$cmnd .= " --unique";}
            if(exists $opt{blocks}){$cmnd .= " --blocks";}
            if(exists $opt{mutations}){$cmnd .= " --mutations=$opt{mutations}";}
            if(exists $opt{discarded}){$cmnd .= " --discarded=$opt{discarded}";}

	}
}


system $cmnd;
print STDOUT $cmnd;


if(exists $opt{blocks}){
    system "mv $prefix"."_hittable_cDNAs.txt $opt{hittable}";
    system "mv $prefix"."_file_statistics_cDNAs.txt $opt{stats}";
    system "mv $prefix"."_intron_and_UTR_overlap_cDNAs.gtf $opt{intronUTRoverlap}";
    
    if($opt{file_type} ne "gtf"){
	system "mv $prefix"."_count_output_cDNAs.gtf $opt{countoutput}";
    }
}
else{
    system "mv $prefix"."_hittable_reads.txt $opt{hittable}";
    system "mv $prefix"."_file_statistics_reads.txt $opt{stats}";
    system "mv $prefix"."_intron_and_UTR_overlap_reads.gtf $opt{intronUTRoverlap}";

    if($opt{file_type} ne "gtf"){
        system "mv $prefix"."_count_output_reads.gtf $opt{countoutput}";
    }
}
