log_file=file("Query_Geo_Database.log", open = "wt")
sink(log_file)
sink(log_file, type = "out")
suppressWarnings(suppressMessages(library("batch")))
suppressWarnings(suppressMessages(library(GEOquery)))
listArguments = parseCommandArgs(evaluate=FALSE)
GeoCode=listArguments[["GeoCode"]]
GeoCode=toupper(GeoCode)
gethelp.df =tryCatch(eList <- getGEOSuppFiles(GeoCode), error = function(cond)"skip")
if(is.null(gethelp.df)){
  gethelp.df =tryCatch(eList <- getGEOSuppFiles(GeoCode), error = function(cond)"skip")
}
if(is.null(gethelp.df)){
  print('GeoCode with no raw data, choose another code or retry.')
}else{
  if(is.data.frame(gethelp.df)==TRUE){
    rawdata=rownames(eList)[grep('RAW',rownames(eList))][1]
    untar(rawdata, exdir = 'CEL')
  }else{
    if(gethelp.df=="skip"){
      print('Network Trouble Try Again Or Check your GeoCode')
    }else{
      print('GeoCode with no raw data, choose another code or retry.')
    }
  }
}

