require("ChIPseeker", quietly = TRUE)
require("ChIPpeakAnno", quietly = TRUE)
require("EnsDb.Hsapiens.v75", quietly = TRUE)
require("data.table", quietly = TRUE)

options(warn = -1)
options("download.file.method"="wget")

args <- commandArgs(trailingOnly = TRUE)
DMR = args[1]
annoPeakFigure = args[2]

DMRInfo = fread(
  DMR,
  header = FALSE,
  sep = "\t",
  stringsAsFactors = FALSE,
  quote = ""
)

peaks <- GRanges(seqnames = DMRInfo[, 1],
                 ranges = IRanges
                 (start = DMRInfo[, 2], end = DMRInfo[, 3]))

annoData <- toGRanges(EnsDb.Hsapiens.v75)
seqlevelsStyle(peaks) <- seqlevelsStyle(annoData)

  
anno <- annoPeaks(peaks, annoData=annoData,bindingType ="startSite")


png(file = annoPeakFigure,
    width = 1200,
    height = 600)

pie1(table(anno$insideFeature))

dev.off()

