require("ChIPpeakAnno", quietly = TRUE)
require("EnsDb.Hsapiens.v75", quietly = TRUE)
require("EnsDb.Mmusculus.v75", quietly = TRUE)

options(warn = -1)
options("download.file.method"="wget")

args <- commandArgs(trailingOnly = TRUE) 
DMR = args[1]
annoData = args[2]
bindingType = args[3]
upstream = as.numeric(args[4])
downstream = as.numeric(args[5])
ignore = args[6]
annoPeakTable = args[7]

#DMR <- ("test-data/DMR.bed")
DMRInfo = read.table(
  DMR,
  header = FALSE,
  sep = "\t",
  stringsAsFactors = FALSE,
  quote = ""
)

peaks <- GRanges(seqnames = DMRInfo[, 1],
                    ranges = IRanges
                    (start = DMRInfo[, 2], end = DMRInfo[, 3]))


if (annoData == "human"){
  annoData <- toGRanges(EnsDb.Hsapiens.v75)
} else {
  annoData <- toGRanges(EnsDb.Mmusculus.v75)
}
seqlevelsStyle(peaks) <- seqlevelsStyle(annoData)

if (ignore == "true"){
  x <- TRUE
} else {
  x <- FALSE
  }


if (bindingType =="startSite"){
anno <- annoPeaks(peaks, annoData=annoData, bindingType =c("startSite"), bindingRegion=c(upstream, downstream), ignore.peak.strand = x)
} else if (bindingType =="endSite"){
  anno <- annoPeaks(peaks, annoData=annoData, bindingType =c("endSite"),  bindingRegion=c(upstream, downstream), ignore.peak.strand = x)  
} else {
  anno <- annoPeaks(peaks, annoData=annoData, bindingType =c("fullRange"),  bindingRegion=c(upstream, downstream), ignore.peak.strand = x)  
}
  

write.table(anno, annoPeakTable, row.names = FALSE)
