require("BiocGenerics", quietly = TRUE)
require("data.table", quietly = TRUE)
require("bumphunter", quietly = TRUE)

args <- commandArgs(trailingOnly = TRUE)
GSMTable = args[1]
platform = args[2]
Data_Table = args[3]
cutoff = as.numeric(args[4])
clusterSize = as.numeric(args[5])
DMR = args[6]

TAB = fread(GSMTable)

IlmnInfo = fread(platform)

gmSet = fread(Data_Table)

# bumphunter Run with processed data
designMatrix <- model.matrix( ~ TAB$Phenotype)

bumps <- bumphunter(
  as.matrix(gmSet),
  design = designMatrix,
  pos = IlmnInfo$BP,
  cutoff = cutoff,
  chr = IlmnInfo$CHR
)

# choose DMR's of a certain length threshold
DMRTable <- bumps$table[which(bumps$table$L >= clusterSize), ]
DMRInfo <- data.table(DMRTable$chr, DMRTable$start, DMRTable$end)


write.table(
  DMRInfo,
  DMR,
  quote = F,
  sep = "\t",
  row.names = F,
  col.names = F
)
