require("minfi", quietly = TRUE)

options(warn = -1)
options("download.file.method"="wget")

args <- commandArgs(trailingOnly = TRUE)
input1 = args[1]
input2 = args[2]
cutoff = as.numeric(args[3])
B = as.numeric(args[4]) 
pickCutoffQ = as.numeric(args[5])
output1 = args[6]
output2 = args[7]

GRset <- get(load(input1))

pheno <- fread(input2)

designMatrix <- model.matrix(~ pheno$Phenotype)

dmrs <- bumphunter(GRset, design = designMatrix,
                   cutoff =cutoff, B=B, type="Beta",  pickCutoff=TRUE,
                   pickCutoffQ=pickCutoffQ)

DMRTable <- dmrs$table

write.table(DMRTable, output1)

sign=sign(DMRTable$value)

sign[sign==-1]="-"
sign[sign==1]="+"

dmr_track<-cbind(as.character(DMRTable$chr),DMRTable$start,DMRTable$end,sign)

write.table(dmr_track,output2,quote = FALSE, sep = "\t\t\t\t",row.names = FALSE, col.names = FALSE,append=TRUE)