require("GEOquery", quietly = TRUE)


options(warn = -1)
options("download.file.method"="wget")
args <- commandArgs(trailingOnly = TRUE)
GSMTable = args[1]
MetaTable = args[2]

TAB = read.table(GSMTable)


if (is.null(TAB)) {
  stop("Must specify input files")
} else {
  options(download.file.method.GEOquery = "wget") 


  GEODataTable <- getGEO(TAB$ID[1], getGPL = FALSE)
  MetaData <- data.frame(Meta(GEODataTable))

  write.table(MetaData, MetaTable, row.names = FALSE, sep = "\t")
}

