/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.samtools.util.SeekableStream;

public class SeekableFileStream
extends SeekableStream {
    File file;
    RandomAccessFile fis;

    public SeekableFileStream(File file) throws FileNotFoundException {
        this.file = file;
        this.fis = new RandomAccessFile(file, "r");
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean eof() throws IOException {
        return this.fis.length() == this.fis.getFilePointer();
    }

    @Override
    public void seek(long position) throws IOException {
        this.fis.seek(position);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n;
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < length; n += count) {
            count = this.fis.read(buffer, offset + n, length - n);
            if (count >= 0) continue;
            if (n > 0) {
                return n;
            }
            return count;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public String getSource() {
        return this.file.getAbsolutePath();
    }
}

