/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.io.FixedStepContig;
import edu.unc.genomics.io.VariableStepContig;
import edu.unc.genomics.io.WigFileException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.broad.igv.bbfile.WigItem;

public abstract class Contig
extends Interval
implements Serializable {
    private static final long serialVersionUID = 7665673936467048945L;
    private int span;
    private long startLine;
    private long stopLine;
    private Map<Integer, Long> index = new HashMap<Integer, Long>();
    protected static final String FIXED_STEP = "fixedStep";
    protected static final String VARIABLE_STEP = "variableStep";

    protected Contig(String chr, int start, int stop, int span) {
        super(chr, start, stop);
        this.span = span;
    }

    public static Contig parse(String headerLine) throws WigFileException {
        if (headerLine.startsWith(FIXED_STEP)) {
            return FixedStepContig.parse(headerLine);
        }
        if (headerLine.startsWith(VARIABLE_STEP)) {
            return VariableStepContig.parse(headerLine);
        }
        throw new WigFileException("Unknown Contig type: " + headerLine);
    }

    public abstract Iterator<WigItem> query(RandomAccessFile var1, String var2, int var3, int var4) throws IOException, WigFileException;

    public void storeIndex(int bp, long pos) {
        this.index.put(bp, pos);
    }

    public long getIndex(int bp) {
        return this.index.get(bp);
    }

    public int getUpstreamIndexedBP(int bp) {
        int closestBP = -1;
        for (int indexBP : this.index.keySet()) {
            if (indexBP <= closestBP || indexBP > bp) continue;
            closestBP = indexBP;
        }
        return closestBP;
    }

    public int getSpan() {
        return this.span;
    }

    public long getStartLine() {
        return this.startLine;
    }

    public void setStartLine(long startLine) {
        this.startLine = startLine;
    }

    public long getStopLine() {
        return this.stopLine;
    }

    public void setStopLine(long stopLine) {
        this.stopLine = stopLine;
    }
}

