/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.io.LineReader;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LineReaderIterator
implements Iterator<String> {
    private static Logger log = Logger.getLogger(LineReaderIterator.class);
    private final LineReader reader;
    private String nextLine;

    public LineReaderIterator(LineReader reader) {
        this.reader = reader;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public String next() {
        String line = this.nextLine;
        this.advance();
        return line;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove records from a BufferedReaderIterator");
    }

    private void advance() {
        try {
            this.nextLine = this.reader.readLine();
        }
        catch (IOException e) {
            log.error((Object)"Error getting next line from BufferedReader");
            e.printStackTrace();
            this.nextLine = null;
            throw new RuntimeException("Error getting next line from BufferedReader");
        }
    }
}

