/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.apache.log4j.Logger;

public class RPChromosomeRegion {
    private static Logger log = Logger.getLogger(RPChromosomeRegion.class);
    private int startChromID;
    private int startBase;
    private int endChromID;
    private int endBase;

    public RPChromosomeRegion(int startChromID, int startBase, int endChromID, int endBase) {
        this.startChromID = startChromID;
        this.startBase = startBase;
        this.endChromID = endChromID;
        this.endBase = endBase;
    }

    public RPChromosomeRegion(RPChromosomeRegion region) {
        this.startChromID = region.startChromID;
        this.startBase = region.startBase;
        this.endChromID = region.endChromID;
        this.endBase = region.endBase;
    }

    public RPChromosomeRegion() {
    }

    public int getStartChromID() {
        return this.startChromID;
    }

    public int getStartBase() {
        return this.startBase;
    }

    public int getEndChromID() {
        return this.endChromID;
    }

    public int getEndBase() {
        return this.endBase;
    }

    public void print() {
        log.debug((Object)"Chromosome bounds:");
        log.debug((Object)("StartChromID = " + this.startChromID));
        log.debug((Object)("StartBase = " + this.startBase));
        log.debug((Object)("EndChromID = " + this.endChromID));
        log.debug((Object)("EndBase = " + this.endBase));
    }

    public int compareRegions(RPChromosomeRegion testRegion) {
        if (this.containedIn(testRegion)) {
            return 0;
        }
        if (this.disjointBelow(testRegion)) {
            return -2;
        }
        if (this.disjointAbove(testRegion)) {
            return 2;
        }
        if (this.intersectsBelow(testRegion)) {
            return -1;
        }
        if (this.intersectsAbove(testRegion)) {
            return 1;
        }
        return 3;
    }

    public boolean equals(RPChromosomeRegion testRegion) {
        return this.startChromID == testRegion.startChromID && this.startBase == testRegion.startBase && this.endChromID == testRegion.endChromID && this.endBase == testRegion.endBase;
    }

    public boolean containedIn(RPChromosomeRegion testRegion) {
        if (this.startChromID > testRegion.startChromID || this.startChromID == testRegion.startChromID && this.startBase >= testRegion.startBase) {
            return this.endChromID < testRegion.endChromID || this.endChromID == testRegion.endChromID && this.endBase <= testRegion.endBase;
        }
        return false;
    }

    public boolean intersectsBelow(RPChromosomeRegion testRegion) {
        if (this.startChromID < testRegion.startChromID || this.startChromID == testRegion.startChromID && this.startBase < testRegion.startBase) {
            return this.endChromID > testRegion.startChromID || this.endChromID == testRegion.startChromID && this.endBase > testRegion.startBase;
        }
        return false;
    }

    public boolean intersectsAbove(RPChromosomeRegion testRegion) {
        if (this.endChromID > testRegion.endChromID || this.endChromID == testRegion.endChromID && this.endBase > testRegion.endBase) {
            return this.startChromID < testRegion.endChromID || this.startChromID == testRegion.endChromID && this.startBase < testRegion.endBase;
        }
        return false;
    }

    public boolean disjointBelow(RPChromosomeRegion testRegion) {
        return this.endChromID < testRegion.startChromID || this.endChromID == testRegion.startChromID && this.endBase <= testRegion.startBase;
    }

    public boolean disjointAbove(RPChromosomeRegion testRegion) {
        return this.startChromID > testRegion.endChromID || this.startChromID == testRegion.endChromID && this.startBase >= testRegion.endBase;
    }

    public RPChromosomeRegion getExtremes(RPChromosomeRegion testRegion) {
        RPChromosomeRegion newRegion = new RPChromosomeRegion(this);
        if (testRegion.startChromID < newRegion.startChromID || testRegion.startChromID == newRegion.startChromID && testRegion.startBase < newRegion.startBase) {
            newRegion.startChromID = testRegion.startChromID;
            newRegion.startBase = testRegion.startBase;
        }
        if (testRegion.endChromID > newRegion.endChromID || testRegion.endChromID == newRegion.endChromID && testRegion.endBase > newRegion.endBase) {
            newRegion.endChromID = testRegion.endChromID;
            newRegion.endBase = testRegion.endBase;
        }
        return newRegion;
    }

    public void expand(RPChromosomeRegion testRegion) {
        if (testRegion.startChromID < this.startChromID || testRegion.startChromID == this.startChromID && testRegion.startBase < this.startBase) {
            this.startChromID = testRegion.startChromID;
            this.startBase = testRegion.startBase;
        }
        if (testRegion.endChromID > this.endChromID || testRegion.endChromID == this.endChromID && testRegion.endBase > this.endBase) {
            this.endChromID = testRegion.endChromID;
            this.endBase = testRegion.endBase;
        }
    }
}

