/*
 * Decompiled with CFR 0.152.
 */
package ed.javatools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private byte[] bytebuffer;
    private int bufferlength;
    private int maxread;
    private int buffpos;
    private StringBuilder sb;

    public BufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this(file, mode, 65536);
    }

    public BufferedRandomAccessFile(File file, String mode, int bufferlength) throws FileNotFoundException {
        super(file, mode);
        this.bufferlength = bufferlength;
        this.bytebuffer = new byte[bufferlength];
        this.maxread = 0;
        this.buffpos = 0;
        this.sb = new StringBuilder("0");
    }

    public int getbuffpos() {
        return this.buffpos;
    }

    @Override
    public int read() throws IOException {
        if (this.buffpos >= this.maxread) {
            this.maxread = this.readchunk();
            if (this.maxread == -1) {
                return -1;
            }
        }
        ++this.buffpos;
        return this.bytebuffer[this.buffpos - 1] & 0xFF;
    }

    public String readLine2() throws IOException {
        this.sb.delete(0, this.sb.length());
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            this.sb.append((char)c);
        }
        if (c == -1 && this.sb.length() == 0) {
            return null;
        }
        return this.sb.toString();
    }

    @Override
    public long getFilePointer() throws IOException {
        return super.getFilePointer() + (long)this.buffpos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void seek(long pos) throws IOException {
        if (this.maxread != -1 && pos < super.getFilePointer() + (long)this.maxread && pos > super.getFilePointer()) {
            Long diff = pos - super.getFilePointer();
            if (diff >= Integer.MAX_VALUE) throw new IOException("something wrong w/ seek");
            this.buffpos = diff.intValue();
            return;
        } else {
            this.buffpos = 0;
            super.seek(pos);
            this.maxread = this.readchunk();
        }
    }

    public int getBufferlength() {
        return this.bufferlength;
    }

    private int readchunk() throws IOException {
        long pos = super.getFilePointer() + (long)this.buffpos;
        super.seek(pos);
        int read = super.read(this.bytebuffer);
        super.seek(pos);
        this.buffpos = 0;
        return read;
    }
}

