/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDST_2D {
    private int rows;
    private int columns;
    private double[] t;
    private DoubleDST_1D dstColumns;
    private DoubleDST_1D dstRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDST_2D(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = n;
        this.columns = n2;
        if (n * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(n) && ConcurrencyUtils.isPowerOf2(n2)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 4 * this.oldNthreads * n;
            if (n2 == 2 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (n2 < 2 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
        }
        this.dstColumns = new DoubleDST_1D(n2);
        this.dstRows = n2 == n ? this.dstColumns : new DoubleDST_1D(n);
    }

    public void forward(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = 4 * n * this.rows;
                if (this.columns == 2 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * n) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, dArray, bl);
                this.ddxt2d0_subth(-1, dArray, bl);
            } else {
                this.ddxt2d_sub(-1, dArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dstColumns.forward(dArray, i * this.columns, bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            DoubleDST_2D.this.dstColumns.forward(dArray, i * DoubleDST_2D.this.columns, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[DoubleDST_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            for (n = 0; n < DoubleDST_2D.this.rows; ++n) {
                                dArray2[n] = dArray[n * DoubleDST_2D.this.columns + i];
                            }
                            DoubleDST_2D.this.dstRows.forward(dArray2, bl);
                            for (n = 0; n < DoubleDST_2D.this.rows; ++n) {
                                dArray[n * ((DoubleDST_2D)DoubleDST_2D.this).columns + i] = dArray2[n];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstColumns.forward(dArray, i * this.columns, bl);
            }
            double[] dArray2 = new double[this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray2[n6] = dArray[n6 * this.columns + i];
                }
                this.dstRows.forward(dArray2, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray[n6 * this.columns + i] = dArray2[n6];
                }
            }
        }
    }

    public void forward(final double[][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = 4 * n * this.rows;
                if (this.columns == 2 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * n) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, dArray, bl);
                this.ddxt2d0_subth(-1, dArray, bl);
            } else {
                this.ddxt2d_sub(-1, dArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dstColumns.forward(dArray[i], bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            DoubleDST_2D.this.dstColumns.forward(dArray[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[DoubleDST_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            for (n = 0; n < DoubleDST_2D.this.rows; ++n) {
                                dArray2[n] = dArray[n][i];
                            }
                            DoubleDST_2D.this.dstRows.forward(dArray2, bl);
                            for (n = 0; n < DoubleDST_2D.this.rows; ++n) {
                                dArray[n][i] = dArray2[n];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstColumns.forward(dArray[i], bl);
            }
            double[] dArray2 = new double[this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray2[n6] = dArray[n6][i];
                }
                this.dstRows.forward(dArray2, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray[n6][i] = dArray2[n6];
                }
            }
        }
    }

    public void inverse(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = 4 * n * this.rows;
                if (this.columns == 2 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * n) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, dArray, bl);
                this.ddxt2d0_subth(1, dArray, bl);
            } else {
                this.ddxt2d_sub(1, dArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dstColumns.inverse(dArray, i * this.columns, bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            DoubleDST_2D.this.dstColumns.inverse(dArray, i * DoubleDST_2D.this.columns, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[DoubleDST_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            for (n = 0; n < DoubleDST_2D.this.rows; ++n) {
                                dArray2[n] = dArray[n * DoubleDST_2D.this.columns + i];
                            }
                            DoubleDST_2D.this.dstRows.inverse(dArray2, bl);
                            for (n = 0; n < DoubleDST_2D.this.rows; ++n) {
                                dArray[n * ((DoubleDST_2D)DoubleDST_2D.this).columns + i] = dArray2[n];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstColumns.inverse(dArray, i * this.columns, bl);
            }
            double[] dArray2 = new double[this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray2[n6] = dArray[n6 * this.columns + i];
                }
                this.dstRows.inverse(dArray2, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray[n6 * this.columns + i] = dArray2[n6];
                }
            }
        }
    }

    public void inverse(final double[][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n != this.oldNthreads) {
                this.nt = 4 * n * this.rows;
                if (this.columns == 2 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * n) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, dArray, bl);
                this.ddxt2d0_subth(1, dArray, bl);
            } else {
                this.ddxt2d_sub(1, dArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dstColumns.inverse(dArray[i], bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            DoubleDST_2D.this.dstColumns.inverse(dArray[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[DoubleDST_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            for (n = 0; n < DoubleDST_2D.this.rows; ++n) {
                                dArray2[n] = dArray[n][i];
                            }
                            DoubleDST_2D.this.dstRows.inverse(dArray2, bl);
                            for (n = 0; n < DoubleDST_2D.this.rows; ++n) {
                                dArray[n][i] = dArray2[n];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstColumns.inverse(dArray[i], bl);
            }
            double[] dArray2 = new double[this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray2[n6] = dArray[n6][i];
                }
                this.dstRows.inverse(dArray2, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray[n6][i] = dArray2[n6];
                }
            }
        }
    }

    private void ddxt2d_subth(final int n, final double[] dArray, final boolean bl) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2 * n2) {
            n3 >>= 1;
        } else if (this.columns < 2 * n2) {
            n2 = this.columns;
            n3 >>= 2;
        }
        final int n4 = n2;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            final int n5 = i;
            final int n6 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block17: {
                        int n11;
                        block18: {
                            int n2;
                            int n3;
                            int n42;
                            block16: {
                                if (DoubleDST_2D.this.columns <= 2 * n4) break block16;
                                if (n == -1) {
                                    for (int i = 4 * n5; i < DoubleDST_2D.this.columns; i += 4 * n4) {
                                        int n52;
                                        int n62;
                                        int n7;
                                        for (n7 = 0; n7 < DoubleDST_2D.this.rows; ++n7) {
                                            n62 = n7 * DoubleDST_2D.this.columns + i;
                                            n52 = n6 + DoubleDST_2D.this.rows + n7;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n6 + n7] = dArray[n62];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n52] = dArray[n62 + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n52 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n62 + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n52 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n62 + 3];
                                        }
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6, bl);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6 + DoubleDST_2D.this.rows, bl);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6 + 2 * DoubleDST_2D.this.rows, bl);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6 + 3 * DoubleDST_2D.this.rows, bl);
                                        for (n7 = 0; n7 < DoubleDST_2D.this.rows; ++n7) {
                                            n62 = n7 * DoubleDST_2D.this.columns + i;
                                            n52 = n6 + DoubleDST_2D.this.rows + n7;
                                            dArray[n62] = DoubleDST_2D.this.t[n6 + n7];
                                            dArray[n62 + 1] = DoubleDST_2D.this.t[n52];
                                            dArray[n62 + 2] = DoubleDST_2D.this.t[n52 + DoubleDST_2D.this.rows];
                                            dArray[n62 + 3] = DoubleDST_2D.this.t[n52 + 2 * DoubleDST_2D.this.rows];
                                        }
                                    }
                                } else {
                                    for (int i = 4 * n5; i < DoubleDST_2D.this.columns; i += 4 * n4) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < DoubleDST_2D.this.rows; ++n10) {
                                            n9 = n10 * DoubleDST_2D.this.columns + i;
                                            n8 = n6 + DoubleDST_2D.this.rows + n10;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n6 + n10] = dArray[n9];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n8] = dArray[n9 + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n8 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n9 + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n8 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n9 + 3];
                                        }
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6, bl);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6 + DoubleDST_2D.this.rows, bl);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6 + 2 * DoubleDST_2D.this.rows, bl);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6 + 3 * DoubleDST_2D.this.rows, bl);
                                        for (n10 = 0; n10 < DoubleDST_2D.this.rows; ++n10) {
                                            n9 = n10 * DoubleDST_2D.this.columns + i;
                                            n8 = n6 + DoubleDST_2D.this.rows + n10;
                                            dArray[n9] = DoubleDST_2D.this.t[n6 + n10];
                                            dArray[n9 + 1] = DoubleDST_2D.this.t[n8];
                                            dArray[n9 + 2] = DoubleDST_2D.this.t[n8 + DoubleDST_2D.this.rows];
                                            dArray[n9 + 3] = DoubleDST_2D.this.t[n8 + 2 * DoubleDST_2D.this.rows];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDST_2D.this.columns != 2 * n4) break block18;
                            for (n42 = 0; n42 < DoubleDST_2D.this.rows; ++n42) {
                                n3 = n42 * DoubleDST_2D.this.columns + 2 * n5;
                                n2 = n6 + n42;
                                ((DoubleDST_2D)DoubleDST_2D.this).t[n2] = dArray[n3];
                                ((DoubleDST_2D)DoubleDST_2D.this).t[n2 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n3 + 1];
                            }
                            if (n == -1) {
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6, bl);
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6 + DoubleDST_2D.this.rows, bl);
                            } else {
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6, bl);
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6 + DoubleDST_2D.this.rows, bl);
                            }
                            for (n42 = 0; n42 < DoubleDST_2D.this.rows; ++n42) {
                                n3 = n42 * DoubleDST_2D.this.columns + 2 * n5;
                                n2 = n6 + n42;
                                dArray[n3] = DoubleDST_2D.this.t[n2];
                                dArray[n3 + 1] = DoubleDST_2D.this.t[n2 + DoubleDST_2D.this.rows];
                            }
                            break block17;
                        }
                        if (DoubleDST_2D.this.columns != n4) break block17;
                        for (n11 = 0; n11 < DoubleDST_2D.this.rows; ++n11) {
                            ((DoubleDST_2D)DoubleDST_2D.this).t[n6 + n11] = dArray[n11 * DoubleDST_2D.this.columns + n5];
                        }
                        if (n == -1) {
                            DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6, bl);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6, bl);
                        }
                        for (n11 = 0; n11 < DoubleDST_2D.this.rows; ++n11) {
                            dArray[n11 * ((DoubleDST_2D)DoubleDST_2D.this).columns + n5] = DoubleDST_2D.this.t[n6 + n11];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d_subth(final int n, final double[][] dArray, final boolean bl) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2 * n2) {
            n3 >>= 1;
        } else if (this.columns < 2 * n2) {
            n2 = this.columns;
            n3 >>= 2;
        }
        final int n4 = n2;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            final int n5 = i;
            final int n6 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block17: {
                        int n8;
                        block18: {
                            int n2;
                            int n3;
                            block16: {
                                if (DoubleDST_2D.this.columns <= 2 * n4) break block16;
                                if (n == -1) {
                                    for (int i = 4 * n5; i < DoubleDST_2D.this.columns; i += 4 * n4) {
                                        int n42;
                                        int n52;
                                        for (n52 = 0; n52 < DoubleDST_2D.this.rows; ++n52) {
                                            n42 = n6 + DoubleDST_2D.this.rows + n52;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n6 + n52] = dArray[n52][i];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n42] = dArray[n52][i + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n42 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n52][i + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n42 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n52][i + 3];
                                        }
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6, bl);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6 + DoubleDST_2D.this.rows, bl);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6 + 2 * DoubleDST_2D.this.rows, bl);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6 + 3 * DoubleDST_2D.this.rows, bl);
                                        for (n52 = 0; n52 < DoubleDST_2D.this.rows; ++n52) {
                                            n42 = n6 + DoubleDST_2D.this.rows + n52;
                                            dArray[n52][i] = DoubleDST_2D.this.t[n6 + n52];
                                            dArray[n52][i + 1] = DoubleDST_2D.this.t[n42];
                                            dArray[n52][i + 2] = DoubleDST_2D.this.t[n42 + DoubleDST_2D.this.rows];
                                            dArray[n52][i + 3] = DoubleDST_2D.this.t[n42 + 2 * DoubleDST_2D.this.rows];
                                        }
                                    }
                                } else {
                                    for (int i = 4 * n5; i < DoubleDST_2D.this.columns; i += 4 * n4) {
                                        int n62;
                                        int n7;
                                        for (n7 = 0; n7 < DoubleDST_2D.this.rows; ++n7) {
                                            n62 = n6 + DoubleDST_2D.this.rows + n7;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n6 + n7] = dArray[n7][i];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n62] = dArray[n7][i + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n62 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n7][i + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n62 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n7][i + 3];
                                        }
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6, bl);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6 + DoubleDST_2D.this.rows, bl);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6 + 2 * DoubleDST_2D.this.rows, bl);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6 + 3 * DoubleDST_2D.this.rows, bl);
                                        for (n7 = 0; n7 < DoubleDST_2D.this.rows; ++n7) {
                                            n62 = n6 + DoubleDST_2D.this.rows + n7;
                                            dArray[n7][i] = DoubleDST_2D.this.t[n6 + n7];
                                            dArray[n7][i + 1] = DoubleDST_2D.this.t[n62];
                                            dArray[n7][i + 2] = DoubleDST_2D.this.t[n62 + DoubleDST_2D.this.rows];
                                            dArray[n7][i + 3] = DoubleDST_2D.this.t[n62 + 2 * DoubleDST_2D.this.rows];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDST_2D.this.columns != 2 * n4) break block18;
                            for (n3 = 0; n3 < DoubleDST_2D.this.rows; ++n3) {
                                n2 = n6 + n3;
                                ((DoubleDST_2D)DoubleDST_2D.this).t[n2] = dArray[n3][2 * n5];
                                ((DoubleDST_2D)DoubleDST_2D.this).t[n2 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = dArray[n3][2 * n5 + 1];
                            }
                            if (n == -1) {
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6, bl);
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6 + DoubleDST_2D.this.rows, bl);
                            } else {
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6, bl);
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6 + DoubleDST_2D.this.rows, bl);
                            }
                            for (n3 = 0; n3 < DoubleDST_2D.this.rows; ++n3) {
                                n2 = n6 + n3;
                                dArray[n3][2 * n5] = DoubleDST_2D.this.t[n2];
                                dArray[n3][2 * n5 + 1] = DoubleDST_2D.this.t[n2 + DoubleDST_2D.this.rows];
                            }
                            break block17;
                        }
                        if (DoubleDST_2D.this.columns != n4) break block17;
                        for (n8 = 0; n8 < DoubleDST_2D.this.rows; ++n8) {
                            ((DoubleDST_2D)DoubleDST_2D.this).t[n6 + n8] = dArray[n8][n5];
                        }
                        if (n == -1) {
                            DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, n6, bl);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, n6, bl);
                        }
                        for (n8 = 0; n8 < DoubleDST_2D.this.rows; ++n8) {
                            dArray[n8][n5] = DoubleDST_2D.this.t[n6 + n8];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d0_subth(final int n, final double[] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n3; i < DoubleDST_2D.this.rows; i += n2) {
                            DoubleDST_2D.this.dstColumns.forward(dArray, i * DoubleDST_2D.this.columns, bl);
                        }
                    } else {
                        for (int i = n3; i < DoubleDST_2D.this.rows; i += n2) {
                            DoubleDST_2D.this.dstColumns.inverse(dArray, i * DoubleDST_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d0_subth(final int n, final double[][] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n3; i < DoubleDST_2D.this.rows; i += n2) {
                            DoubleDST_2D.this.dstColumns.forward(dArray[i], bl);
                        }
                    } else {
                        for (int i = n3; i < DoubleDST_2D.this.rows; i += n2) {
                            DoubleDST_2D.this.dstColumns.inverse(dArray[i], bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d_sub(int n, double[] dArray, boolean bl) {
        block13: {
            int n2;
            int n3;
            block12: {
                if (this.columns <= 2) break block12;
                if (n == -1) {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n4;
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n5 = n6 * this.columns + i;
                            n4 = this.rows + n6;
                            this.t[n6] = dArray[n5];
                            this.t[n4] = dArray[n5 + 1];
                            this.t[n4 + this.rows] = dArray[n5 + 2];
                            this.t[n4 + 2 * this.rows] = dArray[n5 + 3];
                        }
                        this.dstRows.forward(this.t, 0, bl);
                        this.dstRows.forward(this.t, this.rows, bl);
                        this.dstRows.forward(this.t, 2 * this.rows, bl);
                        this.dstRows.forward(this.t, 3 * this.rows, bl);
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n5 = n6 * this.columns + i;
                            n4 = this.rows + n6;
                            dArray[n5] = this.t[n6];
                            dArray[n5 + 1] = this.t[n4];
                            dArray[n5 + 2] = this.t[n4 + this.rows];
                            dArray[n5 + 3] = this.t[n4 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n9 * this.columns + i;
                            n7 = this.rows + n9;
                            this.t[n9] = dArray[n8];
                            this.t[n7] = dArray[n8 + 1];
                            this.t[n7 + this.rows] = dArray[n8 + 2];
                            this.t[n7 + 2 * this.rows] = dArray[n8 + 3];
                        }
                        this.dstRows.inverse(this.t, 0, bl);
                        this.dstRows.inverse(this.t, this.rows, bl);
                        this.dstRows.inverse(this.t, 2 * this.rows, bl);
                        this.dstRows.inverse(this.t, 3 * this.rows, bl);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n9 * this.columns + i;
                            n7 = this.rows + n9;
                            dArray[n8] = this.t[n9];
                            dArray[n8 + 1] = this.t[n7];
                            dArray[n8 + 2] = this.t[n7 + this.rows];
                            dArray[n8 + 3] = this.t[n7 + 2 * this.rows];
                        }
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n3 * this.columns;
                this.t[n3] = dArray[n2];
                this.t[this.rows + n3] = dArray[n2 + 1];
            }
            if (n == -1) {
                this.dstRows.forward(this.t, 0, bl);
                this.dstRows.forward(this.t, this.rows, bl);
            } else {
                this.dstRows.inverse(this.t, 0, bl);
                this.dstRows.inverse(this.t, this.rows, bl);
            }
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n3 * this.columns;
                dArray[n2] = this.t[n3];
                dArray[n2 + 1] = this.t[this.rows + n3];
            }
        }
    }

    private void ddxt2d_sub(int n, double[][] dArray, boolean bl) {
        block13: {
            int n2;
            block12: {
                if (this.columns <= 2) break block12;
                if (n == -1) {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n3;
                        int n4;
                        for (n4 = 0; n4 < this.rows; ++n4) {
                            n3 = this.rows + n4;
                            this.t[n4] = dArray[n4][i];
                            this.t[n3] = dArray[n4][i + 1];
                            this.t[n3 + this.rows] = dArray[n4][i + 2];
                            this.t[n3 + 2 * this.rows] = dArray[n4][i + 3];
                        }
                        this.dstRows.forward(this.t, 0, bl);
                        this.dstRows.forward(this.t, this.rows, bl);
                        this.dstRows.forward(this.t, 2 * this.rows, bl);
                        this.dstRows.forward(this.t, 3 * this.rows, bl);
                        for (n4 = 0; n4 < this.rows; ++n4) {
                            n3 = this.rows + n4;
                            dArray[n4][i] = this.t[n4];
                            dArray[n4][i + 1] = this.t[n3];
                            dArray[n4][i + 2] = this.t[n3 + this.rows];
                            dArray[n4][i + 3] = this.t[n3 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n5 = this.rows + n6;
                            this.t[n6] = dArray[n6][i];
                            this.t[n5] = dArray[n6][i + 1];
                            this.t[n5 + this.rows] = dArray[n6][i + 2];
                            this.t[n5 + 2 * this.rows] = dArray[n6][i + 3];
                        }
                        this.dstRows.inverse(this.t, 0, bl);
                        this.dstRows.inverse(this.t, this.rows, bl);
                        this.dstRows.inverse(this.t, 2 * this.rows, bl);
                        this.dstRows.inverse(this.t, 3 * this.rows, bl);
                        for (n6 = 0; n6 < this.rows; ++n6) {
                            n5 = this.rows + n6;
                            dArray[n6][i] = this.t[n6];
                            dArray[n6][i + 1] = this.t[n5];
                            dArray[n6][i + 2] = this.t[n5 + this.rows];
                            dArray[n6][i + 3] = this.t[n5 + 2 * this.rows];
                        }
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            for (n2 = 0; n2 < this.rows; ++n2) {
                this.t[n2] = dArray[n2][0];
                this.t[this.rows + n2] = dArray[n2][1];
            }
            if (n == -1) {
                this.dstRows.forward(this.t, 0, bl);
                this.dstRows.forward(this.t, this.rows, bl);
            } else {
                this.dstRows.inverse(this.t, 0, bl);
                this.dstRows.inverse(this.t, this.rows, bl);
            }
            for (n2 = 0; n2 < this.rows; ++n2) {
                dArray[n2][0] = this.t[n2];
                dArray[n2][1] = this.t[this.rows + n2];
            }
        }
    }
}

