/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BBZoomLevelHeader {
    private static Logger log = Logger.getLogger(BBZoomLevelHeader.class);
    public static final int ZOOM_LEVEL_HEADER_SIZE = 24;
    private SeekableStream fis;
    private long zoomLevelHeaderOffset;
    int zoomLevel;
    private int reductionLevel;
    private int reserved;
    private long dataOffset;
    private long indexOffset;

    public BBZoomLevelHeader(SeekableStream fis, long fileOffset, int zoomLevel, boolean isLowToHigh) {
        this.fis = fis;
        this.zoomLevelHeaderOffset = fileOffset;
        this.zoomLevel = zoomLevel;
        this.readZoomLevelHeader(this.zoomLevelHeaderOffset, this.zoomLevel, isLowToHigh);
    }

    public BBZoomLevelHeader(int zoomLevel, int reductionLevel, int reserved, long dataOffset, long indexOffset) {
        this.zoomLevel = zoomLevel;
        this.reductionLevel = reductionLevel;
        this.reserved = reserved;
        this.dataOffset = dataOffset;
        this.indexOffset = indexOffset;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public int getReductionLevel() {
        return this.reductionLevel;
    }

    public int getReserved() {
        return this.reserved;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public void print() {
        System.out.println("Zoom level " + this.zoomLevel + " header Table D: ");
        System.out.println("Number of zoom level bases = " + this.reductionLevel);
        System.out.println("Reserved = " + this.reserved);
        System.out.println("Zoom data offset = " + this.dataOffset);
        System.out.println("Zoom index offset = " + this.indexOffset);
    }

    private void readZoomLevelHeader(long fileOffset, int zoomLevel, boolean isLowToHigh) {
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[24];
        try {
            this.fis.seek(fileOffset);
            this.fis.readFully(buffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            }
            if (isLowToHigh) {
                this.reductionLevel = lbdis.readInt();
                this.reserved = lbdis.readInt();
                this.dataOffset = lbdis.readLong();
                this.indexOffset = lbdis.readLong();
            } else {
                this.reductionLevel = bdis.readInt();
                this.reserved = bdis.readInt();
                this.dataOffset = bdis.readLong();
                this.indexOffset = bdis.readLong();
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error reading zoom level header: " + zoomLevel), (Throwable)ex);
            throw new RuntimeException("Error reading zoom header " + zoomLevel, ex);
        }
    }
}

