/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatingPointEqualityChecker;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class DoubleFFT_2DTest {
    public static final String DEFAULT_MESSAGE = "%d-threaded FFT of size %dx%d: ";
    public static final int SEED = 20110602;
    private final DoubleFFT_1D cfft;
    private final DoubleFFT_2D fft;
    private final int numCols;
    private final int numRows;
    private final DoubleFFT_1D rfft;
    private final Random random;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        int[] nArray = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                arrayList.add(new Object[]{nArray[i], nArray[j], 1, 20110602});
                arrayList.add(new Object[]{nArray[i], nArray[j], 4, 20110602});
            }
        }
        return arrayList;
    }

    public DoubleFFT_2DTest(int n, int n2, int n3, long l) {
        this.numRows = n;
        this.numCols = n2;
        this.rfft = new DoubleFFT_1D(n2);
        this.cfft = new DoubleFFT_1D(n);
        this.fft = new DoubleFFT_2D(n, n2);
        this.random = new Random(l);
        ConcurrencyUtils.setNumberOfThreads(n3);
        ConcurrencyUtils.setThreadsBeginN_2D(4);
    }

    public void complexForward(double[][] dArray) {
        for (int i = 0; i < this.numRows; ++i) {
            this.rfft.complexForward(dArray[i]);
        }
        double[] dArray2 = new double[2 * this.numRows];
        for (int i = 0; i < this.numCols; ++i) {
            int n;
            for (n = 0; n < this.numRows; ++n) {
                dArray2[2 * n] = dArray[n][2 * i];
                dArray2[2 * n + 1] = dArray[n][2 * i + 1];
            }
            this.cfft.complexForward(dArray2);
            for (n = 0; n < this.numRows; ++n) {
                dArray[n][2 * i] = dArray2[2 * n];
                dArray[n][2 * i + 1] = dArray2[2 * n + 1];
            }
        }
    }

    public FloatingPointEqualityChecker createEqualityChecker(double d, double d2) {
        String string = String.format(DEFAULT_MESSAGE, ConcurrencyUtils.getNumberOfThreads(), this.numRows, this.numCols);
        return new FloatingPointEqualityChecker(string, d, d2, 0.0f, 0.0f);
    }

    @Test
    public void testComplexForward1dInput() {
        double d;
        int n;
        int n2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(Math.ulp(1.0), 0.0);
        double[] dArray = new double[2 * this.numRows * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                dArray[2 * n2 * this.numCols + n] = d = this.random.nextDouble();
                dArray2[n2][n] = d;
            }
        }
        this.fft.complexForward(dArray);
        this.complexForward(dArray2);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                d = dArray2[n2][n];
                double d2 = dArray[2 * n2 * this.numCols + n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", d, d2);
            }
        }
    }

    @Test
    public void testComplexForward2dInput() {
        double d;
        int n;
        int n2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(Math.ulp(1.0), 0.0);
        double[][] dArray = new double[this.numRows][2 * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                dArray[n2][n] = d = this.random.nextDouble();
                dArray2[n2][n] = d;
            }
        }
        this.fft.complexForward(dArray);
        this.complexForward(dArray2);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                d = dArray2[n2][n];
                double d2 = dArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", d, d2);
            }
        }
    }

    @Test
    public void testComplexInverseScaled1dInput() {
        double d;
        int n;
        double d2 = 1.0E-8;
        double d3 = 5.0E-8;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[] dArray = new double[2 * this.numRows * this.numCols];
        double[] dArray2 = new double[2 * this.numRows * this.numCols];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = d = this.random.nextDouble();
            dArray[n] = d;
        }
        this.fft.complexForward(dArray2);
        this.fft.complexInverse(dArray2, true);
        for (n = 0; n < dArray2.length; ++n) {
            d = dArray[n];
            double d5 = dArray2[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", d, d5);
        }
    }

    @Test
    public void testComplexInverseScaled2dInput() {
        double d;
        int n;
        int n2;
        double d2 = 1.0E-8;
        double d3 = 5.0E-8;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][] dArray = new double[this.numRows][2 * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                dArray2[n2][n] = d = this.random.nextDouble();
                dArray[n2][n] = d;
            }
        }
        this.fft.complexForward(dArray2);
        this.fft.complexInverse(dArray2, true);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                d = dArray[n2][n];
                double d5 = dArray2[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", d, d5);
            }
        }
    }

    @Test
    public void testComplexInverseUnScaled1dInput() {
        double d = 1.0E-8;
        double d2 = 5.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.numRows * this.numCols];
        double[] dArray2 = new double[2 * this.numRows * this.numCols];
        for (int i = 0; i < dArray2.length; ++i) {
            double d4;
            dArray2[i] = d4 = this.random.nextDouble();
            dArray[i] = d4;
        }
        this.fft.complexForward(dArray2);
        this.fft.complexInverse(dArray2, false);
        double d5 = this.numRows * this.numCols;
        for (int i = 0; i < dArray2.length; ++i) {
            double d6 = d5 * dArray[i];
            double d7 = dArray2[i];
            floatingPointEqualityChecker.assertEquals("[" + i + "]", d6, d7);
        }
    }

    @Test
    public void testComplexInverseUnScaled2dInput() {
        double d = 1.0E-8;
        double d2 = 5.0E-8;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[][] dArray = new double[this.numRows][2 * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < 2 * this.numCols; ++j) {
                double d4;
                dArray[i][j] = d4 = this.random.nextDouble();
                dArray2[i][j] = d4;
            }
        }
        this.fft.complexForward(dArray2);
        this.fft.complexInverse(dArray2, false);
        double d5 = this.numRows * this.numCols;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < 2 * this.numCols; ++j) {
                double d6 = d5 * dArray[i][j];
                double d7 = dArray2[i][j];
                floatingPointEqualityChecker.assertEquals("[" + i + "][" + j + "]", d6, d7);
            }
        }
    }

    @Test
    public void testRealForward1dInput() {
        double d;
        int n;
        int n2;
        int n3;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        double d2 = 1.0E-8;
        double d3 = 5.0E-8;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[] dArray = new double[this.numRows * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        boolean[] blArray = new boolean[this.numRows * this.numCols];
        Arrays.fill(blArray, false);
        for (n3 = 0; n3 < this.numRows; ++n3) {
            for (int i = 0; i < this.numCols; ++i) {
                double d5;
                dArray[n3 * this.numCols + i] = d5 = this.random.nextDouble();
                dArray2[n3][2 * i] = d5;
                dArray2[n3][2 * i + 1] = 0.0;
            }
        }
        this.fft.realForward(dArray);
        this.complexForward(dArray2);
        for (n2 = 1; n2 < this.numRows; ++n2) {
            for (n = 2; n < this.numCols; ++n) {
                double d6 = dArray2[n2][n];
                n3 = n2 * this.numCols + n;
                d = dArray[n3];
                floatingPointEqualityChecker.assertEquals("[" + n3 + "]", d6, d);
                blArray[n3] = true;
            }
        }
        for (n2 = 2; n2 < this.numCols; ++n2) {
            double d7 = dArray2[0][n2];
            d = dArray[n2];
            floatingPointEqualityChecker.assertEquals("[0][" + n2 + "]", d7, d);
            blArray[n2] = true;
        }
        for (n2 = 1; n2 < this.numRows / 2; ++n2) {
            double d8 = dArray2[n2][0];
            n3 = n2 * this.numCols;
            d = dArray[n2 * this.numCols];
            floatingPointEqualityChecker.assertEquals("[" + n3 + "]", d8, d);
            blArray[n3] = true;
            d8 = dArray2[n2][1];
            n3 = n2 * this.numCols + 1;
            d = dArray[n3];
            floatingPointEqualityChecker.assertEquals("[" + n3 + "]", d8, d);
            blArray[n3] = true;
            d8 = dArray2[this.numRows - n2][this.numCols];
            n3 = (this.numRows - n2) * this.numCols + 1;
            d = dArray[n3];
            floatingPointEqualityChecker.assertEquals("[" + n3 + "]", d8, d);
            blArray[n3] = true;
            d8 = dArray2[this.numRows - n2][this.numCols + 1];
            n3 = (this.numRows - n2) * this.numCols;
            d = dArray[n3];
            floatingPointEqualityChecker.assertEquals("[" + n3 + "]", d8, d);
            blArray[n3] = true;
        }
        double d9 = dArray2[0][0];
        d = dArray[0];
        floatingPointEqualityChecker.assertEquals("[0]", d9, d);
        blArray[0] = true;
        d9 = dArray2[0][this.numCols];
        d = dArray[1];
        floatingPointEqualityChecker.assertEquals("[1]", d9, d);
        blArray[1] = true;
        d9 = dArray2[this.numRows / 2][0];
        n3 = this.numRows / 2 * this.numCols;
        d = dArray[n3];
        floatingPointEqualityChecker.assertEquals("[" + n3 + "]", d9, d);
        blArray[n3] = true;
        d9 = dArray2[this.numRows / 2][this.numCols];
        n3 = this.numRows / 2 * this.numCols + 1;
        d = dArray[n3];
        floatingPointEqualityChecker.assertEquals("[" + this.numRows / 2 + "][" + this.numCols + "]", d9, d);
        blArray[n3] = true;
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                n3 = n2 * this.numCols + n;
                Assert.assertTrue((String)String.format("[%d]", n3), (boolean)blArray[n3]);
            }
        }
    }

    @Test
    public void testRealForward2dInput() {
        int n;
        int n2;
        double d;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        double d2 = 1.0E-8;
        double d3 = 5.0E-8;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        boolean[][] blArray = new boolean[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                dArray[i][j] = d = this.random.nextDouble();
                dArray2[i][2 * j] = d;
                dArray2[i][2 * j + 1] = 0.0;
                blArray[i][j] = false;
            }
        }
        this.fft.realForward(dArray);
        this.complexForward(dArray2);
        for (n2 = 1; n2 < this.numRows; ++n2) {
            for (n = 2; n < this.numCols; ++n) {
                double d5 = dArray2[n2][n];
                d = dArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", d5, d);
                blArray[n2][n] = true;
            }
        }
        for (n2 = 2; n2 < this.numCols; ++n2) {
            double d6 = dArray2[0][n2];
            d = dArray[0][n2];
            floatingPointEqualityChecker.assertEquals("[0][" + n2 + "]", d6, d);
            blArray[0][n2] = true;
        }
        for (n2 = 1; n2 < this.numRows / 2; ++n2) {
            double d7 = dArray2[n2][0];
            d = dArray[n2][0];
            floatingPointEqualityChecker.assertEquals("[" + n2 + "][0]", d7, d);
            blArray[n2][0] = true;
            d7 = dArray2[n2][1];
            d = dArray[n2][1];
            floatingPointEqualityChecker.assertEquals("[" + n2 + "][1]", d7, d);
            blArray[n2][1] = true;
            d7 = dArray2[this.numRows - n2][this.numCols];
            d = dArray[this.numRows - n2][1];
            floatingPointEqualityChecker.assertEquals("[" + (this.numRows - n2) + "][1]", d7, d);
            blArray[this.numRows - n2][1] = true;
            d7 = dArray2[this.numRows - n2][this.numCols + 1];
            d = dArray[this.numRows - n2][0];
            floatingPointEqualityChecker.assertEquals("[" + (this.numRows - n2) + "][0]", d7, d);
            blArray[this.numRows - n2][0] = true;
        }
        double d8 = dArray2[0][0];
        d = dArray[0][0];
        floatingPointEqualityChecker.assertEquals("[0][0]", d8, d);
        blArray[0][0] = true;
        d8 = dArray2[0][this.numCols];
        d = dArray[0][1];
        floatingPointEqualityChecker.assertEquals("[0][1]", d8, d);
        blArray[0][1] = true;
        d8 = dArray2[this.numRows / 2][0];
        d = dArray[this.numRows / 2][0];
        floatingPointEqualityChecker.assertEquals("[" + this.numRows / 2 + "][0]", d8, d);
        blArray[this.numRows / 2][0] = true;
        d8 = dArray2[this.numRows / 2][this.numCols];
        d = dArray[this.numRows / 2][1];
        floatingPointEqualityChecker.assertEquals("[" + this.numRows / 2 + "][1]", d8, d);
        blArray[this.numRows / 2][1] = true;
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                Assert.assertTrue((String)String.format("[%d][%d]", n2, n), (boolean)blArray[n2][n]);
            }
        }
    }

    @Test
    public void testRealForwardFull1dInput() {
        double d;
        int n;
        int n2;
        double d2 = 1.0E-7;
        double d3 = 5.0E-6;
        if (this.numCols == 511) {
            d3 = 5.0E-5;
        }
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[] dArray = new double[2 * this.numRows * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2 * this.numCols + n] = d = this.random.nextDouble();
                dArray2[n2][2 * n] = d;
                dArray2[n2][2 * n + 1] = 0.0;
            }
        }
        this.fft.realForwardFull(dArray);
        this.complexForward(dArray2);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                d = dArray2[n2][n];
                int n3 = 2 * n2 * this.numCols + n;
                double d5 = dArray[n3];
                floatingPointEqualityChecker.assertEquals("[" + n3 + "]", d, d5);
            }
        }
    }

    @Test
    public void testRealForwardFull2dInput() {
        double d;
        int n;
        int n2;
        double d2 = 1.0E-7;
        double d3 = 5.0E-6;
        if (this.numCols == 511) {
            d3 = 5.0E-5;
        }
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][] dArray = new double[this.numRows][2 * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = d = this.random.nextDouble();
                dArray2[n2][2 * n] = d;
                dArray2[n2][2 * n + 1] = 0.0;
            }
        }
        this.fft.realForwardFull(dArray);
        this.complexForward(dArray2);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                d = dArray2[n2][n];
                double d5 = dArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", d, d5);
            }
        }
    }

    @Test
    public void testRealInverseFullScaled1dInput() {
        int n;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(1.0E-14, 1.0E-15);
        double[] dArray = new double[2 * this.numRows * this.numCols];
        double[] dArray2 = new double[2 * this.numRows * this.numCols];
        for (n = 0; n < this.numRows; ++n) {
            for (int i = 0; i < this.numCols; ++i) {
                double d = this.random.nextDouble();
                int n2 = n * this.numCols + i;
                dArray[n2] = d;
                dArray2[2 * n2] = d;
                dArray2[2 * n2 + 1] = 0.0;
            }
        }
        this.fft.complexInverse(dArray2, true);
        this.fft.realInverseFull(dArray, true);
        for (n = 0; n < dArray.length; ++n) {
            double d = dArray2[n];
            double d2 = dArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", d, d2);
        }
    }

    @Test
    public void testRealInverseFullScaled2dInput() {
        double d;
        int n;
        int n2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(1.0E-14, 1.0E-15);
        double[][] dArray = new double[this.numRows][2 * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = d = this.random.nextDouble();
                dArray2[n2][2 * n] = d;
                dArray2[n2][2 * n + 1] = 0.0;
            }
        }
        this.fft.realInverseFull(dArray, true);
        this.fft.complexInverse(dArray2, true);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                d = dArray2[n2][n];
                double d2 = dArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", d, d2);
            }
        }
    }

    @Test
    public void testRealInverseFullUnscaled1dInput() {
        int n;
        double d = 1.0E-7;
        double d2 = 5.0E-7;
        if (this.numRows == 310 || this.numCols == 310) {
            d2 = 1.0E-6;
        }
        if (this.numRows == 511 || this.numCols == 511) {
            d2 = 5.0E-5;
        }
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[2 * this.numRows * this.numCols];
        double[] dArray2 = new double[2 * this.numRows * this.numCols];
        for (n = 0; n < this.numRows; ++n) {
            for (int i = 0; i < this.numCols; ++i) {
                double d4 = this.random.nextDouble();
                int n2 = n * this.numCols + i;
                dArray[n2] = d4;
                dArray2[2 * n2] = d4;
                dArray2[2 * n2 + 1] = 0.0;
            }
        }
        this.fft.complexInverse(dArray2, false);
        this.fft.realInverseFull(dArray, false);
        for (n = 0; n < dArray.length; ++n) {
            double d5 = dArray2[n];
            double d6 = dArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", d5, d6);
        }
    }

    @Test
    public void testRealInverseFullUnscaled2dInput() {
        double d;
        int n;
        int n2;
        double d2 = 1.0E-7;
        double d3 = 5.0E-7;
        if (this.numRows == 310 || this.numCols == 310) {
            d3 = 1.0E-6;
        }
        if (this.numRows == 511 || this.numCols == 511) {
            d3 = 5.0E-5;
        }
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][] dArray = new double[this.numRows][2 * this.numCols];
        double[][] dArray2 = new double[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = d = this.random.nextDouble();
                dArray2[n2][2 * n] = d;
                dArray2[n2][2 * n + 1] = 0.0;
            }
        }
        this.fft.realInverseFull(dArray, false);
        this.fft.complexInverse(dArray2, false);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                d = dArray2[n2][n];
                double d5 = dArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", d, d5);
            }
        }
    }

    @Test
    public void testRealInverseScaled1dInput() {
        double d;
        int n;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        double d2 = 1.0E-9;
        double d3 = 1.0E-14;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[] dArray = new double[this.numRows * this.numCols];
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = d = this.random.nextDouble();
            dArray2[n] = d;
        }
        this.fft.realForward(dArray);
        this.fft.realInverse(dArray, true);
        for (n = 0; n < dArray.length; ++n) {
            d = dArray2[n];
            double d5 = dArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", d, d5);
        }
    }

    @Test
    public void testRealInverseScaled2dInput() {
        double d;
        int n;
        int n2;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        double d2 = 1.0E-9;
        double d3 = 1.0E-14;
        double d4 = d2 * d3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d2, d4);
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = d = this.random.nextDouble();
                dArray2[n2][n] = d;
            }
        }
        this.fft.realForward(dArray);
        this.fft.realInverse(dArray, true);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                d = dArray2[n2][n];
                double d5 = dArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", d, d5);
            }
        }
    }
}

