/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.io.Contig;
import edu.unc.genomics.io.WigFileException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class FixedStepContig
extends Contig {
    private static final Logger log = Logger.getLogger(FixedStepContigIterator.class);
    private static final long serialVersionUID = -142695785731234833L;
    private int step;

    public FixedStepContig(String chr, int start, int stop, int span, int step) {
        super(chr, start, stop, span);
        this.step = step;
    }

    public static FixedStepContig parse(String headerLine) throws WigFileException {
        String[] tokens = headerLine.split(" ");
        if (tokens.length == 0 || !tokens[0].equals("fixedStep")) {
            throw new WigFileException("Not a valid fixedStep header line: " + headerLine);
        }
        String chr = "";
        int start = 1;
        int span = 1;
        int step = 1;
        block12: for (int i = 1; i < tokens.length; ++i) {
            String s = tokens[i];
            String[] pair = s.split("=");
            if (pair.length != 2) {
                throw new WigFileException("Invalid keypair in fixedStep header line: " + s);
            }
            String key = pair[0];
            String value = pair[1];
            switch (key) {
                case "chrom": {
                    chr = value;
                    continue block12;
                }
                case "start": {
                    start = Integer.parseInt(value);
                    continue block12;
                }
                case "span": {
                    span = Integer.parseInt(value);
                    continue block12;
                }
                case "step": {
                    step = Integer.parseInt(value);
                    continue block12;
                }
                default: {
                    throw new WigFileException("Invalid attribute in fixedStep header line: " + key);
                }
            }
        }
        return new FixedStepContig(chr, start, -1, span, step);
    }

    public long getLineNumForBasePair(int bp) throws WigFileException {
        if (bp < this.getStart() || bp > this.getStop()) {
            throw new WigFileException("Specified base pair (" + bp + ") does not exist in this Contig");
        }
        return this.getStartLine() + (long)((bp - this.getStart()) / this.step);
    }

    public int getBasePairForLineNum(long lineNum) throws WigFileException {
        if (lineNum < this.getStartLine() || lineNum > this.getStopLine()) {
            throw new WigFileException("Line " + lineNum + " is not a part of this contig");
        }
        return (int)((long)this.getStart() + (long)this.step * (lineNum - this.getStartLine()));
    }

    @Override
    public String toString() {
        return "fixedStep chrom=" + this.getChr() + " start=" + this.getStart() + " span=" + this.getSpan() + " step=" + this.step;
    }

    public int getStep() {
        return this.step;
    }

    public FixedStepContigIterator query(RandomAccessFile raf, String chr, int start, int stop) throws IOException, WigFileException {
        return new FixedStepContigIterator(raf, chr, start, stop);
    }

    private class FixedStepContigIterator
    implements Iterator<WigItem> {
        private final RandomAccessFile raf;
        private final String chr;
        private final int low;
        private final int high;
        private final long startLine;
        private final long stopLine;
        private long currentLine;
        private int bp;
        private int itemIndex = 0;

        public FixedStepContigIterator(RandomAccessFile raf, String chr, int start, int stop) throws IOException, WigFileException {
            this.raf = raf;
            this.chr = chr;
            this.low = Math.max(FixedStepContig.this.getStart(), start);
            this.high = Math.min(FixedStepContig.this.getStop(), stop);
            this.startLine = FixedStepContig.this.getLineNumForBasePair(this.low);
            this.stopLine = FixedStepContig.this.getLineNumForBasePair(this.high);
            int closestUpstream = FixedStepContig.this.getUpstreamIndexedBP(this.low);
            raf.seek(FixedStepContig.this.getIndex(closestUpstream));
            this.currentLine = FixedStepContig.this.getLineNumForBasePair(closestUpstream);
            while (this.currentLine < this.startLine) {
                System.out.println(raf.readLine());
                ++this.currentLine;
            }
            this.bp = FixedStepContig.this.getBasePairForLineNum(this.currentLine);
        }

        @Override
        public boolean hasNext() {
            return this.currentLine <= this.stopLine;
        }

        @Override
        public WigItem next() {
            try {
                String line = this.raf.readLine();
                ++this.currentLine;
                float value = Float.parseFloat(line);
                WigItem item = new WigItem(this.itemIndex++, this.chr, this.bp, this.bp + FixedStepContig.this.getSpan() - 1, value);
                this.bp += FixedStepContig.this.getStep();
                return item;
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting next entry in Wig file!");
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from Wig file");
        }
    }
}

