/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import java.io.Serializable;

public class Interval
implements Serializable {
    private static final long serialVersionUID = 7515817773660876485L;
    protected String chr;
    protected int start;
    protected int stop;

    public Interval(String chr, int start, int stop) {
        this.chr = chr;
        this.start = start;
        this.stop = stop;
    }

    public String toBed() {
        return this.chr + "\t" + (this.low() - 1) + "\t" + this.high() + "\t.\t.\t" + this.strand();
    }

    public String toBedGraph() {
        return this.chr + "\t" + (this.low() - 1) + "\t" + this.high();
    }

    public String toGFF() {
        return this.chr + "\tSpotArray\tfeature\t" + this.low() + "\t" + this.high() + "\t.\t" + this.strand() + "\t.\tprobe_id=no_id;count=1";
    }

    public final int center() {
        return (this.start + this.stop) / 2;
    }

    public int length() {
        return Math.abs(this.stop - this.start) + 1;
    }

    public boolean includes(String chr, int bp) {
        return this.chr == chr && this.includes(bp);
    }

    public boolean includes(int bp) {
        return this.low() <= bp && this.high() >= bp;
    }

    public final int low() {
        return Math.min(this.start, this.stop);
    }

    public final int high() {
        return Math.max(this.start, this.stop);
    }

    public final boolean isWatson() {
        return this.stop >= this.start;
    }

    public final boolean isCrick() {
        return !this.isWatson();
    }

    public final String strand() {
        return this.isWatson() ? "+" : "-";
    }

    public String toString() {
        return this.chr + ":" + this.start + "-" + this.stop;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chr == null ? 0 : this.chr.hashCode());
        result = 31 * result + this.start;
        result = 31 * result + this.stop;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.chr == null ? other.chr != null : !this.chr.equals(other.chr)) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.stop == other.stop;
    }

    public String getChr() {
        return this.chr;
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStop() {
        return this.stop;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }
}

