/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.util;

import edu.unc.genomics.util.ExternalSort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);
    public static double DEFAULT_THRESHOLD = 0.3;

    public static boolean isAsciiText(Path p) throws IOException {
        return FileUtils.isAsciiText(p, DEFAULT_THRESHOLD);
    }

    public static boolean isAsciiText(Path p, double threshold) throws IOException {
        int totalCount = 0;
        int binaryCount = 0;
        try (InputStream fis = Files.newInputStream(p, new OpenOption[0]);){
            for (int i = 1; i < 1024; ++i) {
                if (fis.available() == 0) {
                    break;
                }
                int current = fis.read();
                if (current < 32 || current > 127) {
                    ++binaryCount;
                }
                ++totalCount;
            }
        }
        float binaryFraction = (float)binaryCount / (float)totalCount;
        log.debug((Object)("Found " + 100.0f * binaryFraction + "% non-ASCII characters in " + p));
        return (double)binaryFraction < threshold;
    }

    public static int countLines(Path p) throws IOException {
        int count = 0;
        try (BufferedReader reader = Files.newBufferedReader(p, Charset.defaultCharset());){
            String line;
            while ((line = reader.readLine()) != null) {
                ++count;
            }
        }
        return count;
    }

    public static void sort(Path input, Path output, Comparator<String> cmp) throws IOException {
        log.debug((Object)("Sorting file " + input + " to " + output));
        List<Path> pieces = ExternalSort.sortInBatch(input, cmp);
        log.debug((Object)"Merging sorted chunks");
        ExternalSort.mergeSortedFiles(pieces, output, cmp);
    }
}

