/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.ReadablePathValidator;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.sf.picard.fastq.FastqReader;
import net.sf.picard.fastq.FastqRecord;
import org.apache.log4j.Logger;

public class FastqIlluminaToSanger
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FastqIlluminaToSanger.class);
    @Parameter(names={"-i", "--input"}, description="Input file (FASTQ, Illumina)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-o", "--output"}, description="Output file (FASTQ, Sanger)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        int count = 0;
        try (FastqReader reader = new FastqReader(this.inputFile.toFile());
             PrintWriter writer = new PrintWriter(Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]));){
            for (FastqRecord r : reader) {
                writer.print("@");
                writer.println(r.getReadHeader());
                writer.println(r.getReadString());
                writer.print("+");
                writer.println(r.getBaseQualityHeader());
                char[] qual = r.getBaseQualityString().toCharArray();
                int i = 0;
                while (i < qual.length) {
                    int n = i++;
                    qual[n] = (char)(qual[n] - 31);
                }
                writer.println(qual);
                ++count;
            }
        }
        log.info((Object)("Processed " + count + " reads"));
    }

    public static void main(String[] args) {
        new FastqIlluminaToSanger().instanceMain(args);
    }
}

