/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.utils.ArrayScaler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WaveletTransform
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(WaveletTransform.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-w", "--wavelet"}, description="Orthonormal wavelet function (txt)", required=true, validateWith=ReadablePathValidator.class)
    public Path waveletFile;
    @Parameter(names={"-c", "--chr"}, description="Chromosome", required=true)
    public String chr;
    @Parameter(names={"-s", "--start"}, description="Start base pair", required=true)
    public int start;
    @Parameter(names={"-e", "--stop"}, description="Stop base pair", required=true)
    public int stop;
    @Parameter(names={"-m", "--min"}, description="Minimum wavelet size (bp)")
    public int minLength = 100;
    @Parameter(names={"-l", "--max"}, description="Maximum wavelet size (bp)")
    public int maxLength = 200;
    @Parameter(names={"-n", "--step"}, description="Step size (bp)")
    public int stepSize = 1;
    @Parameter(names={"-o", "--output"}, description="Output file (tabular)", required=true)
    public Path outputFile;
    private ArrayScaler scaler;

    @Override
    public void run() throws IOException {
        float[] x;
        log.debug((Object)"Loading wavelet from file");
        ArrayList<Double> waveletList = new ArrayList<Double>();
        try (BufferedReader reader = Files.newBufferedReader(this.waveletFile, Charset.defaultCharset());){
            String line;
            while ((line = reader.readLine()) != null) {
                waveletList.add(Double.valueOf(line));
            }
        }
        log.debug((Object)("Loaded " + waveletList.size() + " values for wavelet"));
        double[] wavelet = new double[waveletList.size()];
        for (int i = 0; i < wavelet.length; ++i) {
            wavelet[i] = (Double)waveletList.get(i);
        }
        log.debug((Object)"Initializing Wavelet scaling interpolator");
        this.scaler = new ArrayScaler(wavelet);
        log.debug((Object)"Loading Wig data");
        try (WigFileReader wig = WigFileReader.autodetect((Path)this.inputFile);){
            x = wig.query(this.chr, this.start, this.stop).getValues();
        }
        catch (WigFileException e) {
            log.error((Object)"Error retrieving data for interval from Wig file");
            e.printStackTrace();
            throw new CommandLineToolException("Error retrieving data for interval from Wig file");
        }
        if (this.maxLength > x.length) {
            log.error((Object)("Maximum wavelet scale size = " + this.maxLength + ", data length = " + x.length));
            throw new CommandLineToolException("Maximum wavelet scale size > size of data!");
        }
        log.debug((Object)"Doing the Wavelet decomposition");
        int numSteps = (this.maxLength - this.minLength) / this.stepSize;
        float[][] matrix = new float[numSteps][x.length];
        for (int i = 0; i < numSteps; ++i) {
            int j;
            int l = this.minLength + i * this.stepSize;
            double[] stretchedWavelet = this.scaler.getScaled(l);
            float sumY = 0.0f;
            float sumSqY = 0.0f;
            for (j = 0; j < l; ++j) {
                sumY = (float)((double)sumY + stretchedWavelet[j]);
                sumSqY = (float)((double)sumSqY + stretchedWavelet[j] * stretchedWavelet[j]);
            }
            for (j = 0; j < x.length - l; ++j) {
                float sumX = 0.0f;
                float sumSqX = 0.0f;
                float sumXY = 0.0f;
                for (int k = 0; k < stretchedWavelet.length; ++k) {
                    sumX += x[j + k];
                    sumSqX += x[j + k] * x[j + k];
                    sumXY = (float)((double)sumXY + (double)x[j + k] * stretchedWavelet[k]);
                }
                matrix[i][j + l / 2] = (float)((double)((float)l * sumXY - sumX * sumY) / Math.sqrt((float)l * sumSqX - sumX * sumX) / Math.sqrt((float)l * sumSqY - sumY * sumY));
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write(this.chr);
            for (int bp = this.start; bp <= this.stop; ++bp) {
                writer.write("\t" + bp);
            }
            for (int i = matrix.length - 1; i >= 0; --i) {
                writer.newLine();
                int l = this.minLength + i * this.stepSize;
                writer.write(String.valueOf(l));
                for (int j = 0; j < x.length; ++j) {
                    writer.write("\t" + matrix[i][j]);
                }
            }
        }
    }

    public static void main(String[] args) {
        new WaveletTransform().instanceMain(args);
    }
}

