/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.utils;

public class SortUtils {
    public static int[] sortIndices(float[] main) {
        int[] index = new int[main.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        SortUtils.quicksort(main, index, 0, index.length - 1);
        return index;
    }

    public static int[] rank(float[] main) {
        int[] sortedIndices = SortUtils.sortIndices(main);
        int[] rank = new int[main.length];
        for (int i = 0; i < rank.length; ++i) {
            rank[sortedIndices[i]] = i + 1;
        }
        return rank;
    }

    private static void quicksort(float[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = SortUtils.partition(a, index, left, right);
        SortUtils.quicksort(a, index, left, i - 1);
        SortUtils.quicksort(a, index, i + 1, right);
    }

    private static int partition(float[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]] && j != left) {
            }
            if (i >= j) break;
            SortUtils.swap(a, index, i, j);
        }
        SortUtils.swap(a, index, i, right);
        return i;
    }

    private static void swap(float[] a, int[] index, int i, int j) {
        int tmp = index[i];
        index[i] = index[j];
        index[j] = tmp;
    }
}

