/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class Multiply
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Multiply.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();

    @Override
    public void setup() {
        log.debug((Object)"Initializing input files");
        for (String inputFile : this.inputFiles) {
            try {
                this.addInputFile(WigFileReader.autodetect((Path)Paths.get(inputFile, new String[0])));
            }
            catch (IOException e) {
                throw new CommandLineToolException(e);
            }
        }
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        float[] product = new float[chunk.length()];
        Arrays.fill(product, 1.0f);
        for (WigFileReader wig : this.inputs) {
            float[] data = wig.query(chunk).getValues();
            for (int i = 0; i < data.length; ++i) {
                if (Float.isNaN(data[i])) continue;
                int n = i;
                product[n] = product[n] * data[i];
            }
        }
        return product;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Multiply().instanceMain(args);
    }
}

