/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.BedEntry;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.BedFileReader;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IntervalAverager
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalAverager.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file (matrix2png format)", required=true)
    public Path outputFile;
    private List<WigFileReader> wigs = new ArrayList<WigFileReader>();
    private int numFiles;
    private List<BedEntry> loci;

    @Override
    public void run() throws IOException {
        int n;
        log.debug((Object)"Initializing input files");
        for (String string : this.inputFiles) {
            try {
                WigFileReader wig = WigFileReader.autodetect((Path)Paths.get(string, new String[0]));
                this.wigs.add(wig);
            }
            catch (IOException e) {
                log.error((Object)("IOError initializing input Wig file: " + string));
                e.printStackTrace();
                throw new CommandLineToolException(e.getMessage());
            }
        }
        this.numFiles = this.wigs.size();
        log.debug((Object)("Initialized " + this.numFiles + " input files"));
        log.debug((Object)"Loading alignment intervals");
        Throwable throwable = null;
        try (BedFileReader bed = new BedFileReader(this.lociFile);){
            this.loci = bed.loadAll();
        }
        catch (Throwable x2) {
            Throwable throwable2 = x2;
            throw x2;
        }
        int leftMax = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (BedEntry entry : this.loci) {
            if (entry.getValue() == null) {
                throw new CommandLineToolException("You must specify an alignment point for each interval in column 5");
            }
            int left = Math.abs(entry.getValue().intValue() - entry.getStart());
            int right = Math.abs(entry.getValue().intValue() - entry.getStop());
            if (left > leftMax) {
                leftMax = left;
            }
            if (right <= n) continue;
            n = right;
        }
        int m = this.loci.size();
        int n3 = leftMax + n + 1;
        int alignmentPoint = leftMax;
        log.info((Object)("Intervals aligned into: " + m + "x" + n3 + " matrix"));
        log.info((Object)("Alignment point: " + alignmentPoint));
        float[][] sum = new float[this.numFiles][n3];
        int[][] counts = new int[this.numFiles][n3];
        int count = 0;
        int skipped = 0;
        log.debug((Object)"Iterating over all intervals");
        for (BedEntry entry : this.loci) {
            int n1 = alignmentPoint - Math.abs(entry.getValue().intValue() - entry.getStart());
            int n22 = alignmentPoint + Math.abs(entry.getValue().intValue() - entry.getStop());
            for (int i = 0; i < this.numFiles; ++i) {
                WigFileReader w = this.wigs.get(i);
                try {
                    float[] data = w.query((Interval)entry).getValues();
                    assert (data.length == n22 - n1 + 1);
                    for (int bp = n1; bp <= n22; ++bp) {
                        if (Float.isNaN(data[bp - n1]) || Float.isInfinite(data[bp - n1])) continue;
                        float[] fArray = sum[i];
                        int n4 = bp;
                        fArray[n4] = fArray[n4] + data[bp - n1];
                        int[] nArray = counts[i];
                        int n5 = bp;
                        nArray[n5] = nArray[n5] + 1;
                    }
                    continue;
                }
                catch (WigFileException e) {
                    log.debug((Object)("Error getting data from wig file " + w.getPath().getFileName() + " for interval " + entry));
                    ++skipped;
                }
            }
            ++count;
        }
        log.info((Object)(count + " intervals processed"));
        log.info((Object)(skipped + " intervals skipped"));
        log.debug((Object)"Computing average(s)");
        float[][] avg = new float[this.numFiles][n3];
        for (int i = 0; i < this.numFiles; ++i) {
            for (int j = 0; j < n3; ++j) {
                avg[i][j] = counts[i][j] == 0 ? Float.NaN : sum[i][j] / (float)counts[i][j];
            }
        }
        log.debug((Object)"Writing average profile(s) to output");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("Position");
            for (WigFileReader w : this.wigs) {
                writer.write("\t" + w.getPath().getFileName());
            }
            writer.newLine();
            for (int i = 0; i < n3; ++i) {
                writer.write(String.valueOf(i - alignmentPoint));
                for (int j = 0; j < this.numFiles; ++j) {
                    writer.write("\t" + avg[j][i]);
                }
                writer.newLine();
            }
        }
        for (WigFileReader w : this.wigs) {
            w.close();
        }
    }

    public static void main(String[] args) {
        new IntervalAverager().instanceMain(args);
    }
}

