/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.PerTileParser;
import net.sf.picard.illumina.parser.PfData;
import net.sf.picard.illumina.parser.readers.FilterFileReader;
import net.sf.picard.util.CollectionUtil;
import net.sf.samtools.util.CloseableIterator;

class FilterParser
extends PerTileParser<PfData> {
    private static Set<IlluminaDataType> supportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.PF));

    public FilterParser(IlluminaFileMap tilesToFiles) {
        super(tilesToFiles);
    }

    public FilterParser(IlluminaFileMap tilesToFiles, int startingTile) {
        super(tilesToFiles, startingTile);
    }

    @Override
    protected CloseableIterator<PfData> makeTileIterator(final File iterator) {
        return new CloseableIterator<PfData>(){
            private FilterFileReader reader;
            {
                this.reader = new FilterFileReader(iterator);
            }

            public void close() {
                this.reader = null;
            }

            public boolean hasNext() {
                return this.reader.hasNext();
            }

            public PfData next() {
                final boolean nextValue = this.reader.next();
                return new PfData(){

                    @Override
                    public boolean isPf() {
                        return nextValue;
                    }
                };
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return supportedTypes;
    }
}

