/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.AbstractSAMHeaderRecord;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.util.StringLineReader;

public class SAMFileHeader
extends AbstractSAMHeaderRecord {
    public static final String VERSION_TAG = "VN";
    public static final String SORT_ORDER_TAG = "SO";
    public static final String GROUP_ORDER_TAG = "GO";
    public static final String CURRENT_VERSION = "1.0";
    private static final String NEXT_VERSION = "1.3";
    public static final Set<String> ACCEPTABLE_VERSIONS = new HashSet<String>(Arrays.asList("1.0", "1.3", "1.4"));
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("VN", "SO", "GO"));
    private List<SAMReadGroupRecord> mReadGroups = new ArrayList<SAMReadGroupRecord>();
    private List<SAMProgramRecord> mProgramRecords = new ArrayList<SAMProgramRecord>();
    private final Map<String, SAMReadGroupRecord> mReadGroupMap = new HashMap<String, SAMReadGroupRecord>();
    private final Map<String, SAMProgramRecord> mProgramRecordMap = new HashMap<String, SAMProgramRecord>();
    private SAMSequenceDictionary mSequenceDictionary = new SAMSequenceDictionary();
    private final List<String> mComments = new ArrayList<String>();
    private String textHeader;
    private final List<SAMValidationError> mValidationErrors = new ArrayList<SAMValidationError>();

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }

    public SAMFileHeader() {
        this.setAttribute(VERSION_TAG, CURRENT_VERSION);
    }

    public String getVersion() {
        return this.getAttribute(VERSION_TAG);
    }

    public String getCreator() {
        return this.getAttribute("CR");
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.mSequenceDictionary;
    }

    public List<SAMReadGroupRecord> getReadGroups() {
        return Collections.unmodifiableList(this.mReadGroups);
    }

    public SAMSequenceRecord getSequence(String name) {
        return this.mSequenceDictionary.getSequence(name);
    }

    public SAMReadGroupRecord getReadGroup(String name) {
        return this.mReadGroupMap.get(name);
    }

    public void setSequenceDictionary(SAMSequenceDictionary sequenceDictionary) {
        this.mSequenceDictionary = sequenceDictionary;
    }

    public void addSequence(SAMSequenceRecord sequenceRecord) {
        this.mSequenceDictionary.addSequence(sequenceRecord);
    }

    public SAMSequenceRecord getSequence(int sequenceIndex) {
        return this.mSequenceDictionary.getSequence(sequenceIndex);
    }

    public int getSequenceIndex(String sequenceName) {
        return this.mSequenceDictionary.getSequenceIndex(sequenceName);
    }

    public void setReadGroups(List<SAMReadGroupRecord> readGroups) {
        this.mReadGroups = readGroups;
        this.mReadGroupMap.clear();
        for (SAMReadGroupRecord readGroupRecord : readGroups) {
            this.mReadGroupMap.put(readGroupRecord.getReadGroupId(), readGroupRecord);
        }
    }

    public void addReadGroup(SAMReadGroupRecord readGroup) {
        if (this.mReadGroupMap.containsKey(readGroup.getReadGroupId())) {
            throw new IllegalArgumentException("Read group with group id " + readGroup.getReadGroupId() + " already exists in SAMFileHeader!");
        }
        this.mReadGroups.add(readGroup);
        this.mReadGroupMap.put(readGroup.getReadGroupId(), readGroup);
    }

    public List<SAMProgramRecord> getProgramRecords() {
        return Collections.unmodifiableList(this.mProgramRecords);
    }

    public void addProgramRecord(SAMProgramRecord programRecord) {
        if (this.mProgramRecordMap.containsKey(programRecord.getProgramGroupId())) {
            throw new IllegalArgumentException("Program record with group id " + programRecord.getProgramGroupId() + " already exists in SAMFileHeader!");
        }
        this.mProgramRecords.add(programRecord);
        this.mProgramRecordMap.put(programRecord.getProgramGroupId(), programRecord);
    }

    public SAMProgramRecord getProgramRecord(String pgId) {
        return this.mProgramRecordMap.get(pgId);
    }

    public void setProgramRecords(List<SAMProgramRecord> programRecords) {
        this.mProgramRecords = programRecords;
        this.mProgramRecordMap.clear();
        for (SAMProgramRecord programRecord : this.mProgramRecords) {
            this.mProgramRecordMap.put(programRecord.getProgramGroupId(), programRecord);
        }
    }

    public SAMProgramRecord createProgramRecord() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String s = Integer.toString(i);
            if (this.mProgramRecordMap.containsKey(s)) continue;
            SAMProgramRecord ret = new SAMProgramRecord(s);
            this.addProgramRecord(ret);
            return ret;
        }
        throw new IllegalStateException("Surprising number of SAMProgramRecords");
    }

    public SortOrder getSortOrder() {
        if (this.getAttribute(SORT_ORDER_TAG) == null) {
            return SortOrder.unsorted;
        }
        return SortOrder.valueOf(this.getAttribute(SORT_ORDER_TAG));
    }

    public void setSortOrder(SortOrder so) {
        this.setAttribute(SORT_ORDER_TAG, so.name());
    }

    public GroupOrder getGroupOrder() {
        if (this.getAttribute(GROUP_ORDER_TAG) == null) {
            return GroupOrder.none;
        }
        return GroupOrder.valueOf(this.getAttribute(GROUP_ORDER_TAG));
    }

    public void setGroupOrder(GroupOrder go) {
        this.setAttribute(GROUP_ORDER_TAG, go.name());
    }

    public String getTextHeader() {
        return this.textHeader;
    }

    public void setTextHeader(String textHeader) {
        this.textHeader = textHeader;
    }

    public List<String> getComments() {
        return Collections.unmodifiableList(this.mComments);
    }

    public void addComment(String comment) {
        if (!comment.startsWith(SAMTextHeaderCodec.COMMENT_PREFIX)) {
            comment = SAMTextHeaderCodec.COMMENT_PREFIX + comment;
        }
        this.mComments.add(comment);
    }

    public void setComments(Collection<String> comments) {
        this.mComments.clear();
        for (String comment : comments) {
            this.addComment(comment);
        }
    }

    public List<SAMValidationError> getValidationErrors() {
        return Collections.unmodifiableList(this.mValidationErrors);
    }

    public void addValidationError(SAMValidationError error) {
        this.mValidationErrors.add(error);
    }

    public void setValidationErrors(Collection<SAMValidationError> errors) {
        this.mValidationErrors.clear();
        this.mValidationErrors.addAll(errors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMFileHeader that = (SAMFileHeader)o;
        if (!this.attributesEqual(that)) {
            return false;
        }
        if (this.mProgramRecords != null ? !this.mProgramRecords.equals(that.mProgramRecords) : that.mProgramRecords != null) {
            return false;
        }
        if (this.mReadGroups != null ? !this.mReadGroups.equals(that.mReadGroups) : that.mReadGroups != null) {
            return false;
        }
        return !(this.mSequenceDictionary != null ? !this.mSequenceDictionary.equals(that.mSequenceDictionary) : that.mSequenceDictionary != null);
    }

    public int hashCode() {
        int result = this.attributesHashCode();
        result = 31 * result + (this.mSequenceDictionary != null ? this.mSequenceDictionary.hashCode() : 0);
        result = 31 * result + (this.mReadGroups != null ? this.mReadGroups.hashCode() : 0);
        result = 31 * result + (this.mProgramRecords != null ? this.mProgramRecords.hashCode() : 0);
        return result;
    }

    public final SAMFileHeader clone() {
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        codec.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        StringWriter stringWriter = new StringWriter();
        codec.encode(stringWriter, this);
        return codec.decode(new StringLineReader(stringWriter.toString()), "SAMFileHeader.clone");
    }

    public static enum GroupOrder {
        none,
        query,
        reference;

    }

    public static enum SortOrder {
        unsorted(null),
        queryname(SAMRecordQueryNameComparator.class),
        coordinate(SAMRecordCoordinateComparator.class);

        private final Class<? extends SAMRecordComparator> comparator;

        private SortOrder(Class<? extends SAMRecordComparator> comparatorClass) {
            this.comparator = comparatorClass;
        }

        public Class<? extends SAMRecordComparator> getComparator() {
            return this.comparator;
        }

        public SAMRecordComparator getComparatorInstance() {
            if (this.comparator != null) {
                try {
                    Constructor<? extends SAMRecordComparator> ctor = this.comparator.getConstructor(new Class[0]);
                    return ctor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not instantiate a comparator for sort order: " + this.name(), e);
                }
            }
            return null;
        }
    }
}

