/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.utils;

import edu.unc.utils.SortUtils;

public class FloatCorrelation {
    public static float pearson(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Length of x (" + x.length + ") does not equal length of y (" + y.length + ")");
        }
        int N = 0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumSqX = 0.0;
        double sumSqY = 0.0;
        double sumXY = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (Float.isNaN(x[i]) || Float.isInfinite(x[i]) || Float.isNaN(y[i]) || Float.isInfinite(y[i])) continue;
            ++N;
            sumX += (double)x[i];
            sumY += (double)y[i];
            sumSqX += (double)(x[i] * x[i]);
            sumSqY += (double)(y[i] * y[i]);
            sumXY += (double)(x[i] * y[i]);
        }
        return (float)(((double)N * sumXY - sumX * sumY) / Math.sqrt((double)N * sumSqX - sumX * sumX) / Math.sqrt((double)N * sumSqY - sumY * sumY));
    }

    public static float spearman(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Length of x (" + x.length + ") does not equal length of y (" + y.length + ")");
        }
        float[] rankX = FloatCorrelation.mapToFloat(SortUtils.rank(x));
        float[] rankY = FloatCorrelation.mapToFloat(SortUtils.rank(y));
        return FloatCorrelation.pearson(rankX, rankY);
    }

    private static float[] mapToFloat(int[] data) {
        float[] ret = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }
}

