/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class Phasogram
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Phasogram.class);
    @Parameter(names={"-i", "--input"}, description="Input wig file (read counts)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-m", "--max"}, description="Maximum phase shift", required=true)
    public int maxPhase;
    @Parameter(names={"-o", "--output"}, description="Output file (histogram)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        double[] phaseCounts = new double[this.maxPhase + 1];
        try (WigFileReader reader = WigFileReader.autodetect((Path)this.inputFile);){
            for (String chr : reader.chromosomes()) {
                log.debug((Object)("Processing chromosome " + chr));
                int start = reader.getChrStart(chr);
                while (start < reader.getChrStop(chr)) {
                    int stop = Math.min(start + 300000 - 1, reader.getChrStop(chr));
                    log.debug((Object)("Processing chunk " + chr + ":" + start + "-" + stop));
                    int paddedStop = Math.min(stop + this.maxPhase, reader.getChrStop(chr));
                    try {
                        float[] data = reader.query(chr, start, paddedStop).getValues();
                        for (int i = 0; i < data.length - this.maxPhase; ++i) {
                            if (Float.isNaN(data[i]) || Float.isInfinite(data[i])) continue;
                            for (int j = 0; j <= this.maxPhase; ++j) {
                                if (Float.isNaN(data[i + j]) || Float.isInfinite(data[i + j])) continue;
                                int n = j;
                                phaseCounts[n] = phaseCounts[n] + (double)(data[i] * data[i + j]);
                            }
                        }
                    }
                    catch (WigFileException e) {
                        log.fatal((Object)"Error querying data from Wig file!");
                        e.printStackTrace();
                        throw new CommandLineToolException("Error querying data from Wig file!");
                    }
                    start = stop + 1;
                }
            }
        }
        log.debug((Object)"Writing output to disk");
        var3_3 = null;
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]));){
            writer.println("#Phase\tCount");
            for (int i = 0; i < phaseCounts.length; ++i) {
                writer.println(i + "\t" + phaseCounts[i]);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    public static void main(String[] args) {
        new Phasogram().instanceMain(args);
    }
}

