/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class Divide
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Divide.class);
    @Parameter(names={"-n", "--numerator"}, description="Dividend / Numerator (file 1)", required=true, validateWith=ReadablePathValidator.class)
    public Path dividendFile;
    @Parameter(names={"-d", "--denominator"}, description="Divisor / Denominator (file 2)", required=true)
    public Path divisorFile;
    WigFileReader dividendReader;
    WigFileReader divisorReader;

    @Override
    public void setup() {
        try {
            this.dividendReader = WigFileReader.autodetect((Path)this.dividendFile);
            this.divisorReader = WigFileReader.autodetect((Path)this.divisorFile);
        }
        catch (IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.dividendReader);
        this.inputs.add(this.divisorReader);
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        float[] dividend = this.dividendReader.query(chunk).getValues();
        float[] divisor = this.divisorReader.query(chunk).getValues();
        for (int i = 0; i < dividend.length; ++i) {
            if (divisor[i] == 0.0f) {
                dividend[i] = Float.NaN;
                continue;
            }
            int n = i;
            dividend[n] = dividend[n] / divisor[i];
        }
        return dividend;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Divide().instanceMain(args);
    }
}

