/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.utils.FFTUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class PowerSpectrum
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(PowerSpectrum.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-m", "--max"}, description="Only output this many frequencies")
    public int max = 40;
    @Parameter(names={"-o", "--output"}, description="Output file (tabular)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        try (WigFileReader wig = WigFileReader.autodetect((Path)this.inputFile);
             IntervalFileReader loci = IntervalFileReader.autodetect((Path)this.lociFile);
             BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("#chr\tlow\thigh\tid\talignment\tstrand\tPower Spectrum Values");
            writer.newLine();
            log.debug((Object)"Computing power spectrum for each window");
            int skipped = 0;
            for (Interval interval : loci) {
                float[] data;
                try {
                    data = wig.query(interval).getValues();
                }
                catch (WigFileException | IOException e) {
                    log.debug((Object)("Skipping interval: " + interval));
                    ++skipped;
                    continue;
                }
                if (interval.length() > 1) {
                    int i;
                    FloatFFT_1D fft = new FloatFFT_1D(data.length);
                    fft.realForward(data);
                    float[] ps = FFTUtils.abs2(data);
                    float sum = 0.0f;
                    for (i = 1; i < ps.length; ++i) {
                        sum += ps[i];
                    }
                    i = 1;
                    while (i < ps.length) {
                        int n = i++;
                        ps[n] = ps[n] / sum;
                    }
                    writer.write(interval.toBed());
                    for (i = 1; i < Math.min(ps.length, this.max); ++i) {
                        writer.write("\t" + ps[i]);
                    }
                    writer.newLine();
                    continue;
                }
                ++skipped;
                writer.write(interval.toBed());
                writer.newLine();
            }
            log.info((Object)("Skipped " + skipped + " intervals"));
        }
    }

    public static void main(String[] args) {
        new PowerSpectrum().instanceMain(args);
    }
}

