/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class WigMathTool
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(WigMathTool.class);
    public static final int DEFAULT_CHUNK_SIZE = 500000;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    protected List<WigFile> inputs = new ArrayList<WigFile>();

    public void addInputFile(WigFile wig) {
        this.inputs.add(wig);
    }

    public abstract void setup();

    public abstract float[] compute(String var1, int var2, int var3) throws IOException, WigFileException;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Executing setup operations");
        this.setup();
        log.debug((Object)"Processing files and writing result to disk");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("track type=wiggle_0");
            writer.newLine();
            Set<String> chromosomes = this.getCommonChromosomes(this.inputs);
            log.debug((Object)("Found " + chromosomes.size() + " chromosomes in common between all inputs"));
            for (String chr : chromosomes) {
                int start = this.getMaxChrStart(this.inputs, chr);
                int stop = this.getMinChrStop(this.inputs, chr);
                log.debug((Object)("Processing chromosome " + chr + " region " + start + "-" + stop));
                writer.write("fixedStep chrom=" + chr + " start=" + start + " step=1 span=1");
                writer.newLine();
                int bp = start;
                while (bp < stop) {
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + 500000 - 1, stop);
                    int expectedLength = chunkStop - chunkStart + 1;
                    log.debug((Object)("Processing chunk " + chr + ":" + chunkStart + "-" + chunkStop));
                    float[] result = null;
                    try {
                        result = this.compute(chr, chunkStart, chunkStop);
                    }
                    catch (WigFileException e) {
                        log.fatal((Object)("Wig file error while processing chunk " + chr + " region " + start + "-" + stop));
                        e.printStackTrace();
                        throw new RuntimeException("Wig file error while processing chunk " + chr + " region " + start + "-" + stop);
                    }
                    if (result.length != expectedLength) {
                        log.error((Object)("Expected result length=" + expectedLength + ", got=" + result.length));
                        throw new RuntimeException("Result is not the expected length!");
                    }
                    for (int i = 0; i < result.length; ++i) {
                        writer.write(Float.toString(result[i]));
                        writer.newLine();
                    }
                    bp = chunkStop + 1;
                }
            }
        }
        for (WigFile wig : this.inputs) {
            wig.close();
        }
    }

    public int getMaxChrStart(List<WigFile> wigs, String chr) {
        int max = -1;
        for (WigFile wig : wigs) {
            if (wig.getChrStart(chr) <= max) continue;
            max = wig.getChrStart(chr);
        }
        return max;
    }

    public int getMinChrStop(List<WigFile> wigs, String chr) {
        if (wigs.size() == 0) {
            return -1;
        }
        int min = Integer.MAX_VALUE;
        for (WigFile wig : wigs) {
            if (wig.getChrStop(chr) >= min) continue;
            min = wig.getChrStop(chr);
        }
        return min;
    }

    public Set<String> getCommonChromosomes(List<WigFile> wigs) {
        if (wigs.size() == 0) {
            return new HashSet<String>();
        }
        Set chromosomes = wigs.get(0).chromosomes();
        Iterator it = chromosomes.iterator();
        block0: while (it.hasNext()) {
            String chr = (String)it.next();
            for (WigFile wig : wigs) {
                if (wig.includes(chr)) continue;
                it.remove();
                continue block0;
            }
        }
        return chromosomes;
    }
}

