/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.sf.samtools.BAMIndexer;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import org.apache.log4j.Logger;

public class Samtools {
    private static final Logger log = Logger.getLogger(Samtools.class);

    public static void indexBAMFile(SAMFileReader reader, Path output) {
        BAMIndexer indexer = new BAMIndexer(output.toFile(), reader.getFileHeader());
        reader.enableFileSource(true);
        int totalRecords = 0;
        SAMRecordIterator it = reader.iterator();
        while (it.hasNext()) {
            SAMRecord rec = (SAMRecord)it.next();
            if (++totalRecords % 1000000 == 0) {
                log.debug((Object)(totalRecords + " reads processed ..."));
            }
            indexer.processAlignment(rec);
        }
        indexer.finish();
        it.close();
    }

    public static Path findIndexFile(Path bamFile) {
        String bai;
        Path indexFile;
        String bamExtension = ".bam";
        String fileName = bamFile.toString();
        if (fileName.endsWith(".bam") && Files.exists(indexFile = bamFile.resolveSibling(bai = fileName.substring(0, fileName.length() - ".bam".length()) + ".bai"), new LinkOption[0])) {
            return indexFile;
        }
        indexFile = bamFile.resolveSibling(bamFile.getFileName() + ".bai");
        if (Files.exists(indexFile, new LinkOption[0])) {
            return indexFile;
        }
        return null;
    }
}

