/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.ButtonLabel;
import edu.unc.genomics.ResourceManager;
import edu.unc.genomics.SubmittedJob;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class JobQueueCellRenderer
extends JPanel
implements ListCellRenderer<SubmittedJob> {
    private static final long serialVersionUID = 4270263302075586018L;
    private static final ImageIcon inProgressIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("beachball.png").toString());
    private static final ImageIcon rerunIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("arrow-circle.png").toString());
    private static final ImageIcon infoIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("information-white.png").toString());
    private static final ImageIcon logIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("sticky-note-text.png").toString());
    private static final ImageIcon showFileIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("eye_icon.png").toString());
    private static final ImageIcon successIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("icon_success_sml.gif").toString());
    private static final ImageIcon errorIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("icon_error_sml.gif").toString());
    private static final ImageIcon warningIcon = new ImageIcon(ResourceManager.getImagesDirectory().resolve("icon_warning_sml.gif").toString());
    private JLabel statusIconLabel = new JLabel(inProgressIcon);
    private JLabel nameLabel = new JLabel();

    public JobQueueCellRenderer() {
        FlowLayout flowLayout = new FlowLayout(3, 5, 2);
        this.setPreferredSize(new Dimension(190, 48));
        this.setLayout(flowLayout);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true));
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 16, 0));
        statusPanel.setLayout(new BoxLayout(statusPanel, 3));
        statusPanel.add(this.statusIconLabel);
        this.add(statusPanel);
        JPanel mainPanel = new JPanel();
        mainPanel.setAlignmentX(0.0f);
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        JPanel namePanel = new JPanel();
        namePanel.setLayout(flowLayout);
        this.nameLabel.setPreferredSize(new Dimension(145, 16));
        this.nameLabel.setHorizontalTextPosition(2);
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
        namePanel.add(this.nameLabel);
        mainPanel.add(namePanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(flowLayout);
        mainPanel.add(buttonsPanel);
        ButtonLabel rerunLabel = new ButtonLabel(rerunIcon);
        rerunLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        buttonsPanel.add(rerunLabel);
        ButtonLabel infoLabel = new ButtonLabel(infoIcon);
        infoLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        buttonsPanel.add(infoLabel);
        ButtonLabel logLabel = new ButtonLabel(logIcon);
        logLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        buttonsPanel.add(logLabel);
        ButtonLabel showFileLabel = new ButtonLabel(showFileIcon);
        showFileLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        buttonsPanel.add(showFileLabel);
        this.add(mainPanel);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends SubmittedJob> list, SubmittedJob value, int index, boolean isSelected, boolean cellHasFocus) {
        this.nameLabel.setText(value.toString());
        if (value.isRunning()) {
            this.statusIconLabel.setIcon(inProgressIcon);
            this.nameLabel.setForeground(Color.BLACK);
        } else if (value.succeeded()) {
            this.statusIconLabel.setIcon(successIcon);
            this.nameLabel.setForeground(Color.BLACK);
        } else {
            this.statusIconLabel.setIcon(errorIcon);
            this.nameLabel.setForeground(Color.RED);
        }
        return this;
    }
}

