/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.SAMEntry;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.util.Samtools;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;

public class SAMFile
extends IntervalFile<SAMEntry> {
    private static final Logger log = Logger.getLogger(SAMFile.class);
    private SAMFileReader reader;
    private Path index;
    private SAMRecordIterator it;

    public SAMFile(Path p) {
        super(p);
        this.reader = new SAMFileReader(p.toFile());
        if (this.reader.isBinary()) {
            if (!this.reader.hasIndex()) {
                log.debug((Object)("Generating index for BAM file: " + p));
                this.index = p.resolveSibling(p.getFileName() + ".bai");
                Samtools.indexBAMFile(this.reader, this.index);
                this.reader = new SAMFileReader(p.toFile());
            } else {
                this.index = Samtools.findIndexFile(p);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int count() {
        int count = 0;
        if (this.reader.hasIndex()) {
            BAMIndex index = this.reader.getIndex();
            int nRefs = this.reader.getFileHeader().getSequenceDictionary().size();
            for (int i = 0; i < nRefs; ++i) {
                BAMIndexMetaData data = index.getMetaData(i);
                count += data.getAlignedRecordCount();
                count += data.getUnalignedRecordCount();
            }
        } else {
            for (SAMRecord r : this.reader) {
                ++count;
            }
        }
        return count;
    }

    @Override
    public Set<String> chromosomes() {
        HashSet<String> chromosomes = new HashSet<String>();
        SAMSequenceDictionary dict = this.reader.getFileHeader().getSequenceDictionary();
        for (SAMSequenceRecord seqRec : dict.getSequences()) {
            chromosomes.add(seqRec.getSequenceName());
        }
        return chromosomes;
    }

    @Override
    public Iterator<SAMEntry> iterator() {
        if (this.it != null) {
            this.it.close();
        }
        this.it = this.reader.iterator();
        return new SAMEntryIterator();
    }

    @Override
    public Iterator<SAMEntry> query(String chr, int start, int stop) {
        if (this.it != null) {
            this.it.close();
        }
        this.it = this.reader.query(chr, start, stop, false);
        return new SAMEntryIterator();
    }

    private class SAMEntryIterator
    implements Iterator<SAMEntry> {
        private SAMEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return SAMFile.this.it.hasNext();
        }

        @Override
        public SAMEntry next() {
            return new SAMEntry((SAMRecord)SAMFile.this.it.next());
        }

        @Override
        public void remove() {
            SAMFile.this.it.remove();
        }
    }
}

