/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.launch4j.ExecException;
import net.sf.launch4j.Log;
import net.sf.launch4j.Messages;

public class Util {
    public static final boolean WINDOWS_OS = System.getProperty("os.name").toLowerCase().startsWith("windows");

    private Util() {
    }

    public static File createTempFile(String suffix) throws IOException {
        String tmpdir = System.getProperty("launch4j.tmpdir");
        if (tmpdir != null) {
            if (tmpdir.indexOf(32) != -1) {
                throw new IOException(Messages.getString("Util.tmpdir"));
            }
            return File.createTempFile("launch4j", suffix, new File(tmpdir));
        }
        return File.createTempFile("launch4j", suffix);
    }

    public static File getJarBasedir() {
        String url = Util.class.getClassLoader().getResource(Util.class.getName().replace('.', '/') + ".class").getFile().replaceAll("%20", " ");
        if (url.startsWith("file:")) {
            String jar = url.substring(5, url.lastIndexOf(33));
            int x = jar.lastIndexOf(47);
            if (x == -1) {
                x = jar.lastIndexOf(92);
            }
            String basedir = jar.substring(0, x + 1);
            return new File(basedir);
        }
        return new File(".");
    }

    public static File getAbsoluteFile(File basepath, File f) {
        return f.isAbsolute() ? f : new File(basepath, f.getPath());
    }

    public static String getExtension(File f) {
        String name = f.getName();
        int x = name.lastIndexOf(46);
        if (x != -1) {
            return name.substring(x);
        }
        return "";
    }

    public static void exec(String[] cmd, Log log) throws ExecException {
        BufferedReader is = null;
        try {
            StringBuffer sb;
            String line;
            if (WINDOWS_OS) {
                for (int i = 0; i < cmd.length; ++i) {
                    cmd[i] = cmd[i].replaceAll("/", "\\\\");
                }
            }
            Process p = Runtime.getRuntime().exec(cmd);
            is = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            int errLine = -1;
            Pattern pattern = Pattern.compile(":\\d+:");
            while ((line = is.readLine()) != null) {
                log.append(line);
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                errLine = Integer.valueOf(line.substring(matcher.start() + 1, matcher.end() - 1));
                if (!line.matches("(?i).*unrecognized escape sequence")) break;
                log.append(Messages.getString("Util.use.double.backslash"));
                break;
            }
            is.close();
            p.waitFor();
            if (errLine != -1) {
                sb = new StringBuffer(Messages.getString("Util.exec.failed"));
                Util.AppendCommandLine(sb, cmd);
                throw new ExecException(sb.toString(), errLine);
            }
            if (p.exitValue() != 0) {
                sb = new StringBuffer(Messages.getString("Util.exec.failed"));
                sb.append(" (");
                sb.append(p.exitValue());
                sb.append(')');
                Util.AppendCommandLine(sb, cmd);
                throw new ExecException(sb.toString());
            }
        }
        catch (IOException e) {
            Util.close(is);
            throw new ExecException(e);
        }
        catch (InterruptedException e) {
            Util.close(is);
            throw new ExecException(e);
        }
    }

    private static void AppendCommandLine(StringBuffer sb, String[] cmd) {
        sb.append(": ");
        for (int i = 0; i < cmd.length; ++i) {
            sb.append(cmd[i]);
            if (i >= cmd.length - 1) continue;
            sb.append(' ');
        }
    }

    public static void close(InputStream o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static void close(OutputStream o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static void close(Reader o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static void close(Writer o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static boolean delete(File f) {
        return f != null ? f.delete() : false;
    }
}

