/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.BedEntry;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.BedFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class IntervalAverager
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalAverager.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file (matrix2png format)", required=true)
    public Path outputFile;
    private List<BedEntry> loci;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Loading alignment intervals");
        try (BedFile bed = new BedFile(this.lociFile);){
            this.loci = bed.loadAll();
        }
        int leftMax = Integer.MIN_VALUE;
        int rightMax = Integer.MIN_VALUE;
        for (BedEntry entry : this.loci) {
            int left = Math.abs(entry.getValue().intValue() - entry.getStart());
            int right = Math.abs(entry.getValue().intValue() - entry.getStop());
            if (left > leftMax) {
                leftMax = left;
            }
            if (right <= rightMax) continue;
            rightMax = right;
        }
        int m = this.loci.size();
        int n = leftMax + rightMax + 1;
        int alignmentPoint = leftMax;
        log.info((Object)("Intervals aligned into: " + m + "x" + n + " matrix"));
        log.info((Object)("Alignment point: " + alignmentPoint));
        float[] sum = new float[n];
        int[] counts = new int[n];
        int count = 0;
        int skipped = 0;
        log.debug((Object)"Iterating over all intervals");
        for (BedEntry entry : this.loci) {
            Iterator result = null;
            try {
                result = this.inputFile.query((Interval)entry);
            }
            catch (WigFileException e) {
                ++skipped;
                continue;
            }
            float[] data = WigFile.flattenData((Iterator)result, (int)entry.getStart(), (int)entry.getStop());
            if (entry.isCrick()) {
                ArrayUtils.reverse((float[])data);
            }
            int n1 = alignmentPoint - Math.abs(entry.getValue().intValue() - entry.getStart());
            int n2 = alignmentPoint + Math.abs(entry.getValue().intValue() - entry.getStop());
            int bp = n1;
            while (bp <= n2) {
                int n3 = bp;
                sum[n3] = sum[n3] + data[bp - n1];
                int n4 = bp++;
                counts[n4] = counts[n4] + 1;
            }
        }
        this.inputFile.close();
        log.info((Object)(count + " intervals processed"));
        log.info((Object)(skipped + " intervals skipped"));
        log.debug((Object)"Computing average");
        float[] avg = new float[n];
        for (int i = 0; i < n; ++i) {
            avg[i] = counts[i] == 0 ? Float.NaN : sum[i] / (float)counts[i];
        }
        log.debug((Object)"Writing average to output");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            for (int i = 0; i < n; ++i) {
                writer.write(i - alignmentPoint + "\t" + avg[i]);
                writer.newLine();
            }
        }
    }

    public static void main(String[] args) {
        new IntervalAverager().instanceMain(args);
    }
}

