/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.PathConverter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.DataFormatException;

public class AssemblyConverter
implements IStringConverter<Assembly> {
    public static final Path ASSEMBLIES_DIR = Paths.get("resources", "assemblies");

    public Assembly convert(String string) throws ParameterException {
        PathConverter pathConverter;
        Path path = ASSEMBLIES_DIR.resolve(string + ".len");
        if (!Files.isReadable(path) && !Files.isReadable(path = (pathConverter = new PathConverter()).convert(string))) {
            throw new ParameterException("Cannot find Assembly file: " + string);
        }
        try {
            return new Assembly(path);
        }
        catch (IOException | DataFormatException exception) {
            throw new ParameterException("Error loading Assembly from file: " + path);
        }
    }
}

