/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.AssemblyManagerDialog;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Job;
import edu.unc.genomics.JobConfigPanel;
import edu.unc.genomics.JobException;
import edu.unc.genomics.JobQueue;
import edu.unc.genomics.JobQueueCellRenderer;
import edu.unc.genomics.JobQueueManager;
import edu.unc.genomics.SubmittedJob;
import edu.unc.genomics.ToolsTree;
import edu.unc.genomics.ToolsTreeModel;
import edu.unc.genomics.ToolsTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import org.xml.sax.SAXException;

public class ToolRunnerFrame
extends JFrame
implements ApplicationListener {
    private static final long serialVersionUID = 6454774196137357898L;
    private static final Logger log = Logger.getLogger(ToolRunnerFrame.class);
    private final Application application = new DefaultApplication();
    private final JPanel contentPane = new JPanel();
    private final JSplitPane splitPane = new JSplitPane();
    private final JPanel mainPane = new JPanel();
    private final JProgressBar progressBar = new JProgressBar();
    private final JTabbedPane tabbedPane = new JTabbedPane(1);
    private final JobConfigPanel configurationPanel = new JobConfigPanel();
    private final JTextPane helpTextPanel = new JTextPane();
    private final ToolsTree toolsTree = new ToolsTree();
    private final JobQueue queue = new JobQueue();
    private final JobQueueManager queueManager = new JobQueueManager(this.queue);
    private final JList<SubmittedJob> queueList = new JList<SubmittedJob>(this.queue);

    public ToolRunnerFrame() {
        this.application.addApplicationListener((ApplicationListener)this);
        if (this.application.isMac()) {
            this.setDefaultCloseOperation(1);
        } else {
            this.setDefaultCloseOperation(3);
        }
        this.setTitle("Genomics Toolkit Tool Runner");
        this.setBounds(100, 100, 1000, 600);
        this.contentPane.setBorder(BorderFactory.createEmptyBorder());
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.initializeChildren();
        this.initializeMenuBar();
    }

    private void initializeChildren() {
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.contentPane.add((Component)this.splitPane, "Center");
        this.initializeQueuePanel();
        this.initializeToolsTree();
        this.mainPane.setLayout(new BorderLayout(0, 0));
        this.mainPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.mainPane.add((Component)this.tabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.progressBar);
        JButton jButton = new JButton("Run");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolRunnerFrame.this.addJobToQueue();
            }
        });
        jPanel.add(jButton);
        this.mainPane.add((Component)jPanel, "South");
        this.splitPane.setRightComponent(this.mainPane);
        this.initializeConfigurationPanel();
        this.initializeHelpPanel();
    }

    private void initializeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Assembly manager");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                JPopupMenu jPopupMenu = (JPopupMenu)jMenuItem.getParent();
                Component component = jPopupMenu.getInvoker();
                JComponent jComponent = (JComponent)component;
                Container container = jComponent.getTopLevelAncestor();
                AssemblyManagerDialog assemblyManagerDialog = new AssemblyManagerDialog((JFrame)container);
                assemblyManagerDialog.setVisible(true);
            }
        });
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Help");
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem2 = new JMenuItem("Help Contents");
        jMenu2.add(jMenuItem2);
        if (!this.application.isMac()) {
            JMenuItem jMenuItem3 = new JMenuItem("About");
            jMenu2.add(jMenuItem3);
            jMenu2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ToolRunnerFrame.this.handleAbout(null);
                }
            });
        }
    }

    private void initializeQueuePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        this.contentPane.add((Component)jPanel, "East");
        JLabel jLabel = new JLabel("Job Queue");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        this.queueList.setBackground(this.contentPane.getBackground());
        this.queueList.setCellRenderer(new JobQueueCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.queueList);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setBackground(this.contentPane.getBackground());
        jScrollPane.setPreferredSize(new Dimension(200, Integer.MAX_VALUE));
        jPanel.add(jScrollPane);
    }

    private void initializeConfigurationPanel() {
        JScrollPane jScrollPane = new JScrollPane(this.configurationPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.tabbedPane.addTab("Tool Configuration", null, jScrollPane, "Configure tool");
    }

    private void initializeHelpPanel() {
        JPanel jPanel = new JPanel();
        this.tabbedPane.addTab("Help", null, jPanel, null);
        jPanel.setLayout(new BorderLayout(0, 0));
        this.helpTextPanel.setEditable(false);
        this.helpTextPanel.setBackground(this.tabbedPane.getBackground());
        Font font = new Font("Monospaced", this.helpTextPanel.getFont().getStyle(), this.helpTextPanel.getFont().getSize());
        this.helpTextPanel.setFont(font);
        JScrollPane jScrollPane = new JScrollPane(this.helpTextPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add(jScrollPane);
    }

    private void initializeToolsTree() {
        Serializable serializable;
        try {
            serializable = ToolsTreeModel.loadDefaultConfig();
            this.toolsTree.setModel((TreeModel)((Object)serializable));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            log.error((Object)"Error loading tool configuration file");
            exception.printStackTrace();
            System.exit(-1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)("Error loading tool: " + classNotFoundException.getMessage()));
            classNotFoundException.printStackTrace();
            System.exit(-1);
        }
        this.toolsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ToolRunnerFrame.this.changeTool();
            }
        });
        serializable = new JScrollPane(this.toolsTree);
        ((JComponent)serializable).setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
        this.splitPane.setLeftComponent((Component)serializable);
    }

    private void changeTool() {
        Object object = this.toolsTree.getLastSelectedPathComponent();
        if (object == null) {
            return;
        }
        if (object instanceof ToolsTreeNode) {
            ToolsTreeNode toolsTreeNode = (ToolsTreeNode)object;
            try {
                Class<? extends CommandLineTool> clazz = toolsTreeNode.getClazz();
                Job job = new Job(clazz);
                this.configurationPanel.setJob(job);
                this.helpTextPanel.setText(job.getUsageText());
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                log.error((Object)"Error initializing Job");
                reflectiveOperationException.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error initializing job", "Job Initialization Error", 0);
            }
        }
    }

    private void addJobToQueue() {
        Job job = this.configurationPanel.getJob();
        if (job == null) {
            return;
        }
        log.info((Object)"Validating parameters for tool");
        if (!job.validateArguments()) {
            this.configurationPanel.highlightInvalidArguments();
            return;
        }
        try {
            this.queueManager.submitJob(job);
            this.configurationPanel.setJob(null);
        }
        catch (JobException jobException) {
            log.error((Object)"Error adding Job to queue");
            jobException.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error adding job to queue", "Job Queue Error", 0);
        }
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
        JOptionPane.showMessageDialog(this, "Java Genomics Toolkit v1.0");
        if (applicationEvent != null) {
            applicationEvent.setHandled(true);
        }
    }

    public void handleOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleOpenFile(ApplicationEvent applicationEvent) {
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
    }

    public void handlePrintFile(ApplicationEvent applicationEvent) {
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        boolean bl = true;
        if (this.queueManager.isRunning()) {
            int n = JOptionPane.showConfirmDialog(this, "Jobs are currently running. Are you sure you want to quit?", "Confirm Quit", 2);
            boolean bl2 = bl = n == 0;
        }
        if (bl) {
            this.dispose();
            System.exit(0);
        }
    }

    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
        this.setVisible(true);
    }
}

