/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.utils.RomanNumeral;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RomanNumeralize
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(RomanNumeralize.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    Pattern p = Pattern.compile("/chr[\\d]{1,2}/i");

    @Override
    public void run() throws IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(this.inputFile, Charset.defaultCharset());
             BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            String string;
            log.debug((Object)"Copying input to output and replacing with Roman Numerals");
            while ((string = bufferedReader.readLine()) != null) {
                Matcher matcher = this.p.matcher(string);
                StringBuffer stringBuffer = new StringBuffer(string.length());
                while (matcher.find()) {
                    String string2 = string.substring(matcher.start() + 3, matcher.end());
                    int n = Integer.parseInt(string2);
                    String string3 = RomanNumeral.int2roman(n);
                    matcher.appendReplacement(stringBuffer, "chr" + string3);
                }
                matcher.appendTail(stringBuffer);
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.newLine();
            }
        }
    }

    public static void main(String[] stringArray) {
        new RomanNumeralize().instanceMain(stringArray);
    }
}

