/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class IntervalStats
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalStats.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true)
    public IntervalFile<? extends Interval> lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    private List<WigFile> wigs = new ArrayList<WigFile>();

    @Override
    public void run() throws IOException {
        Object object;
        log.debug((Object)"Initializing input Wig file(s)");
        for (String string : this.inputFiles) {
            try {
                object = WigFile.autodetect((Path)Paths.get(string, new String[0]));
                this.wigs.add((WigFile)object);
            }
            catch (WigFileException wigFileException) {
                log.error((Object)("Error initializing Wig input file: " + string));
                wigFileException.printStackTrace();
                throw new RuntimeException("Error initializing Wig input file: " + string);
            }
        }
        log.debug((Object)"Initializing output file");
        int n = 0;
        int n2 = 0;
        object = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
        Throwable throwable4 = null;
        try {
            ((Writer)object).write("#Chr\tStart\tStop\tID\tValue\tStrand");
            for (String string : this.inputFiles) {
                Path path = Paths.get(string, new String[0]);
                ((Writer)object).write("\t" + path.getFileName().toString());
            }
            ((BufferedWriter)object).newLine();
            log.debug((Object)"Iterating over all intervals and computing statistics");
            SummaryStatistics summaryStatistics = new SummaryStatistics();
            for (Path path : this.lociFile) {
                ArrayList<Double> arrayList = new ArrayList<Double>(this.wigs.size());
                for (WigFile wigFile : this.wigs) {
                    summaryStatistics.clear();
                    try {
                        Iterator iterator = wigFile.query((Interval)path);
                        while (iterator.hasNext()) {
                            WigItem wigItem = (WigItem)iterator.next();
                            for (int i = wigItem.getStartBase(); i <= wigItem.getEndBase(); ++i) {
                                summaryStatistics.addValue((double)wigItem.getWigValue());
                            }
                        }
                        arrayList.add(summaryStatistics.getMean());
                    }
                    catch (WigFileException wigFileException) {
                        arrayList.add(Double.NaN);
                        ++n2;
                    }
                }
                ((Writer)object).write(path.toBed() + "\t" + StringUtils.join(arrayList, (String)"\t"));
                ((BufferedWriter)object).newLine();
                ++n;
            }
        }
        catch (Throwable throwable2) {
            throwable4 = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable4 != null) {
                    try {
                        ((BufferedWriter)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable4.addSuppressed(throwable3);
                    }
                } else {
                    ((BufferedWriter)object).close();
                }
            }
        }
        this.lociFile.close();
        for (Throwable throwable4 : this.wigs) {
            throwable4.close();
        }
        log.info((Object)(n + " intervals processed"));
        log.info((Object)(n2 + " interval skipped"));
    }

    public static void main(String[] stringArray) {
        new IntervalStats().instanceMain(stringArray);
    }
}

