/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.nucleosomes.NucleosomeCall;
import edu.unc.genomics.nucleosomes.NucleosomeCallsFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FindBoundaryNucleosomes
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FindBoundaryNucleosomes.class);
    @Parameter(names={"-i", "--input"}, description="Input file (nucleosome calls)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Boundary loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    private Map<String, List<NucleosomeCall>> nucs = new HashMap<String, List<NucleosomeCall>>();

    private List<NucleosomeCall> getIntervalNucleosomes(Interval interval) {
        ArrayList<NucleosomeCall> arrayList = new ArrayList<NucleosomeCall>();
        for (NucleosomeCall nucleosomeCall : this.nucs.get(interval.getChr())) {
            if (nucleosomeCall.getDyad() < interval.low() || nucleosomeCall.getDyad() > interval.high()) continue;
            arrayList.add(nucleosomeCall);
        }
        return arrayList;
    }

    @Override
    public void run() throws IOException {
        Object object;
        log.debug((Object)"Initializing input file");
        NucleosomeCallsFile nucleosomeCallsFile = new NucleosomeCallsFile(this.inputFile);
        log.debug((Object)"Loading all nucleosomes");
        Iterator iterator = nucleosomeCallsFile.iterator();
        while (iterator.hasNext()) {
            object = (NucleosomeCall)iterator.next();
            if (object == null) continue;
            if (!this.nucs.containsKey(object.getChr())) {
                this.nucs.put(object.getChr(), new ArrayList());
            }
            this.nucs.get(object.getChr()).add((NucleosomeCall)object);
        }
        nucleosomeCallsFile.close();
        log.debug((Object)"Initializing output file");
        int n = 0;
        object = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
        Throwable throwable = null;
        try {
            log.debug((Object)"Finding boundary nucleosomes for each interval");
            NucleosomeCall.DyadComparator dyadComparator = new NucleosomeCall.DyadComparator();
            for (Interval interval : this.lociFile) {
                ((Writer)object).write(interval.toBed());
                List<NucleosomeCall> list = this.getIntervalNucleosomes(interval);
                if (list.size() > 0) {
                    Collections.sort(list, dyadComparator);
                    if (interval.isCrick()) {
                        Collections.reverse(list);
                    }
                    int n2 = list.get(0).getDyad();
                    int n3 = list.get(list.size() - 1).getDyad();
                    ((Writer)object).write("\t" + n2 + "\t" + n3);
                } else {
                    ++n;
                    ((Writer)object).write("\tNA\tNA");
                }
                ((BufferedWriter)object).newLine();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((BufferedWriter)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((BufferedWriter)object).close();
                }
            }
        }
        this.lociFile.close();
        log.info((Object)("Skipped " + n + " intervals with 0 nucleosomes"));
    }

    public static void main(String[] stringArray) {
        new FindBoundaryNucleosomes().instanceMain(stringArray);
    }
}

