/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Job;
import edu.unc.genomics.JobException;
import edu.unc.genomics.JobQueue;
import edu.unc.genomics.SubmittedJob;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class JobQueueManager {
    private static final Logger log = Logger.getLogger(JobQueueManager.class);
    private final JobQueue queue;
    private final ExecutorService exec;
    private final Thread monitor;

    public JobQueueManager(JobQueue jobQueue) {
        this.queue = jobQueue;
        int n = Runtime.getRuntime().availableProcessors();
        log.debug((Object)("Initializing thread pool with " + n + " processors"));
        this.exec = Executors.newFixedThreadPool(n);
        this.monitor = new Thread(new JobMonitor());
        this.monitor.start();
    }

    public List<Runnable> shutdownNow() {
        return this.exec.shutdownNow();
    }

    public SubmittedJob submitJob(Job job) throws JobException {
        if (!job.validateArguments()) {
            throw new JobException("Job arguments are not valid");
        }
        Future<?> future = this.exec.submit(job);
        SubmittedJob submittedJob = new SubmittedJob(job, future);
        log.info((Object)("Submitted job " + submittedJob.getId()));
        this.queue.add(submittedJob);
        return submittedJob;
    }

    public boolean isRunning() {
        for (SubmittedJob submittedJob : this.queue) {
            if (submittedJob.isDone()) continue;
            return true;
        }
        return false;
    }

    public class JobMonitor
    implements Runnable {
        public static final int JOB_POLL_INTERVAL = 1000;

        @Override
        public void run() {
            try {
                block2: while (true) {
                    Thread.sleep(1000L);
                    Iterator<SubmittedJob> iterator = JobQueueManager.this.queue.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        SubmittedJob submittedJob = iterator.next();
                        if (!submittedJob.isDone()) continue;
                        JobQueueManager.this.queue.update(submittedJob);
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                log.fatal((Object)"JobMonitor crashed");
                interruptedException.printStackTrace();
                throw new RuntimeException("JobMonitor crashed");
            }
        }
    }
}

