/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.BedEntry;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.BedFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class IntervalAverager
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalAverager.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file (matrix2png format)", required=true)
    public Path outputFile;
    private List<BedEntry> loci;

    @Override
    public void run() throws IOException {
        Object object;
        int n;
        log.debug((Object)"Loading alignment intervals");
        try (BedFile bedFile = new BedFile(this.lociFile);){
            this.loci = bedFile.loadAll();
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (BedEntry bedEntry : this.loci) {
            n = Math.abs(bedEntry.getValue().intValue() - bedEntry.getStart());
            int n4 = Math.abs(bedEntry.getValue().intValue() - bedEntry.getStop());
            if (n > n2) {
                n2 = n;
            }
            if (n4 <= n3) continue;
            n3 = n4;
        }
        int n5 = this.loci.size();
        int n6 = n2 + n3 + 1;
        n = n2;
        log.info((Object)("Intervals aligned into: " + n5 + "x" + n6 + " matrix"));
        log.info((Object)("Alignment point: " + n));
        float[] fArray = new float[n6];
        int[] nArray = new int[n6];
        int n7 = 0;
        int n8 = 0;
        log.debug((Object)"Iterating over all intervals");
        for (BedEntry bedEntry : this.loci) {
            object = null;
            try {
                object = this.inputFile.query((Interval)bedEntry);
            }
            catch (WigFileException wigFileException) {
                ++n8;
                continue;
            }
            float[] fArray2 = WigFile.flattenData((Iterator)object, (int)bedEntry.getStart(), (int)bedEntry.getStop());
            if (bedEntry.isCrick()) {
                ArrayUtils.reverse((float[])fArray2);
            }
            int n9 = n - Math.abs(bedEntry.getValue().intValue() - bedEntry.getStart());
            int n10 = n + Math.abs(bedEntry.getValue().intValue() - bedEntry.getStop());
            int n11 = n9;
            while (n11 <= n10) {
                int n12 = n11;
                fArray[n12] = fArray[n12] + fArray2[n11 - n9];
                int n13 = n11++;
                nArray[n13] = nArray[n13] + 1;
            }
        }
        this.inputFile.close();
        log.info((Object)(n7 + " intervals processed"));
        log.info((Object)(n8 + " intervals skipped"));
        log.debug((Object)"Computing average");
        Object object2 = new float[n6];
        for (int i = 0; i < n6; ++i) {
            object2[i] = nArray[i] == 0 ? (Object)Float.NaN : (Object)(fArray[i] / (float)nArray[i]);
        }
        log.debug((Object)"Writing average to output");
        BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
        object = null;
        try {
            for (int i = 0; i < n6; ++i) {
                bufferedWriter.write(i - n + "\t" + (float)object2[i]);
                bufferedWriter.newLine();
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (bufferedWriter != null) {
                if (object != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    bufferedWriter.close();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        new IntervalAverager().instanceMain(stringArray);
    }
}

