/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LogTransform
extends WigMathTool {
    private static final Logger log = Logger.getLogger(LogTransform.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-b", "--base"}, description="Logarithm base (default = 2)")
    public double base = 2.0;
    private double baseChange;

    @Override
    public void setup() {
        this.baseChange = Math.log(this.base);
        this.inputs.add(this.inputFile);
    }

    @Override
    public float[] compute(String string, int n, int n2) throws IOException, WigFileException {
        log.debug((Object)("Computing difference for chunk " + string + ":" + n + "-" + n2));
        Iterator iterator = this.inputFile.query(string, n, n2);
        float[] fArray = WigFile.flattenData((Iterator)iterator, (int)n, (int)n2);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)(Math.log(fArray[i]) / this.baseChange);
        }
        return fArray;
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new LogTransform().instanceMain(stringArray);
    }
}

