/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ZScore
extends WigMathTool {
    private static final Logger log = Logger.getLogger(ZScore.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    double mean;
    double stdev;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        this.mean = this.inputFile.mean();
        this.stdev = this.inputFile.stdev();
        if (this.stdev == 0.0) {
            log.error((Object)"Cannot Z-score a file with stdev = 0!");
            throw new CommandLineToolException("Cannot Z-score a file with stdev = 0!");
        }
    }

    @Override
    public float[] compute(String string, int n, int n2) throws IOException, WigFileException {
        log.debug((Object)("Computing difference for chunk " + string + ":" + n + "-" + n2));
        Iterator iterator = this.inputFile.query(string, n, n2);
        float[] fArray = WigFile.flattenData((Iterator)iterator, (int)n, (int)n2);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)(((double)fArray[i] - this.mean) / this.stdev);
        }
        return fArray;
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new ZScore().instanceMain(stringArray);
    }
}

