/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleFFT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65530, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static int[] sizes2D2 = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static int[] sizes3D2 = new int[]{2, 4, 8, 16, 32, 64, 128};
    private static double eps = Math.pow(2.0, -52.0);

    private AccuracyCheckDoubleFFT() {
    }

    public static void checkAccuracyComplexFFT_1D() {
        System.out.println("Checking accuracy of 1D complex FFT...");
        for (int i = 0; i < sizes1D.length; ++i) {
            DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D(sizes1D[i]);
            double d = 0.0;
            double[] dArray = new double[2 * sizes1D[i]];
            IOUtils.fillMatrix_1D(2 * sizes1D[i], dArray);
            double[] dArray2 = new double[2 * sizes1D[i]];
            IOUtils.fillMatrix_1D(2 * sizes1D[i], dArray2);
            doubleFFT_1D.complexForward(dArray);
            doubleFFT_1D.complexInverse(dArray, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(dArray, dArray2);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            }
            dArray = null;
            dArray2 = null;
            doubleFFT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyComplexFFT_2D() {
        Object object;
        Object object2;
        double d;
        DoubleFFT_2D doubleFFT_2D;
        int n;
        System.out.println("Checking accuracy of 2D complex FFT (double[] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            doubleFFT_2D = new DoubleFFT_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new double[2 * sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], 2 * sizes2D[n], object2);
            object = new double[2 * sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], 2 * sizes2D[n], object);
            doubleFFT_2D.complexForward((double[])object2);
            doubleFFT_2D.complexInverse((double[])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D complex FFT (double[][] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            doubleFFT_2D = new DoubleFFT_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new double[sizes2D[n]][2 * sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], 2 * sizes2D[n], (double[][])object2);
            object = new double[sizes2D[n]][2 * sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], 2 * sizes2D[n], (double[][])object);
            doubleFFT_2D.complexForward((double[][])object2);
            doubleFFT_2D.complexInverse((double[][])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE((double[][])object2, (double[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyComplexFFT_3D() {
        Object object;
        Object object2;
        double d;
        DoubleFFT_3D doubleFFT_3D;
        int n;
        System.out.println("Checking accuracy of 3D complex FFT (double[] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            doubleFFT_3D = new DoubleFFT_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new double[2 * sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], 2 * sizes3D[n], object2);
            object = new double[2 * sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], 2 * sizes3D[n], object);
            doubleFFT_3D.complexForward((double[])object2);
            doubleFFT_3D.complexInverse((double[])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D complex FFT (double[][][] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            doubleFFT_3D = new DoubleFFT_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new double[sizes3D[n]][sizes3D[n]][2 * sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], 2 * sizes3D[n], (double[][][])object2);
            object = new double[sizes3D[n]][sizes3D[n]][2 * sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], 2 * sizes3D[n], (double[][][])object);
            doubleFFT_3D.complexForward((double[][][])object2);
            doubleFFT_3D.complexInverse((double[][][])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE((double[][][])object2, (double[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_1D() {
        int n;
        double[] dArray;
        double[] dArray2;
        double d;
        DoubleFFT_1D doubleFFT_1D;
        int n2;
        System.out.println("Checking accuracy of 1D real FFT...");
        for (n2 = 0; n2 < sizes1D.length; ++n2) {
            doubleFFT_1D = new DoubleFFT_1D(sizes1D[n2]);
            d = 0.0;
            dArray2 = new double[sizes1D[n2]];
            IOUtils.fillMatrix_1D(sizes1D[n2], dArray2);
            dArray = new double[sizes1D[n2]];
            IOUtils.fillMatrix_1D(sizes1D[n2], dArray);
            doubleFFT_1D.realForward(dArray2);
            doubleFFT_1D.realInverse(dArray2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(dArray2, dArray);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            }
            dArray2 = null;
            dArray = null;
            doubleFFT_1D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of on 1D real forward full FFT...");
        for (n2 = 0; n2 < sizes1D.length; ++n2) {
            doubleFFT_1D = new DoubleFFT_1D(sizes1D[n2]);
            d = 0.0;
            dArray2 = new double[2 * sizes1D[n2]];
            IOUtils.fillMatrix_1D(sizes1D[n2], dArray2);
            dArray = new double[2 * sizes1D[n2]];
            for (n = 0; n < sizes1D[n2]; ++n) {
                dArray[2 * n] = dArray2[n];
            }
            doubleFFT_1D.realForwardFull(dArray2);
            doubleFFT_1D.complexInverse(dArray2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(dArray2, dArray);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            }
            dArray2 = null;
            dArray = null;
            doubleFFT_1D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 1D real inverse full FFT...");
        for (n2 = 0; n2 < sizes1D.length; ++n2) {
            doubleFFT_1D = new DoubleFFT_1D(sizes1D[n2]);
            d = 0.0;
            dArray2 = new double[2 * sizes1D[n2]];
            IOUtils.fillMatrix_1D(sizes1D[n2], dArray2);
            dArray = new double[2 * sizes1D[n2]];
            for (n = 0; n < sizes1D[n2]; ++n) {
                dArray[2 * n] = dArray2[n];
            }
            doubleFFT_1D.realInverseFull(dArray2, true);
            doubleFFT_1D.complexForward(dArray2);
            d = AccuracyCheckDoubleFFT.computeRMSE(dArray2, dArray);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[n2] + ";\terror = " + d);
            }
            dArray2 = null;
            dArray = null;
            doubleFFT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_2D() {
        int n;
        int n2;
        Object object;
        Object object2;
        double d;
        DoubleFFT_2D doubleFFT_2D;
        int n3;
        System.out.println("Checking accuracy of 2D real FFT (double[] input)...");
        for (n3 = 0; n3 < sizes2D2.length; ++n3) {
            doubleFFT_2D = new DoubleFFT_2D(sizes2D2[n3], sizes2D2[n3]);
            d = 0.0;
            object2 = new double[sizes2D2[n3] * sizes2D2[n3]];
            IOUtils.fillMatrix_2D(sizes2D2[n3], sizes2D2[n3], object2);
            object = new double[sizes2D2[n3] * sizes2D2[n3]];
            IOUtils.fillMatrix_2D(sizes2D2[n3], sizes2D2[n3], object);
            doubleFFT_2D.realForward((double[])object2);
            doubleFFT_2D.realInverse((double[])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D2[n3] + " x " + sizes2D2[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D2[n3] + " x " + sizes2D2[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real FFT (double[][] input)...");
        for (n3 = 0; n3 < sizes2D2.length; ++n3) {
            doubleFFT_2D = new DoubleFFT_2D(sizes2D2[n3], sizes2D2[n3]);
            d = 0.0;
            object2 = new double[sizes2D2[n3]][sizes2D2[n3]];
            IOUtils.fillMatrix_2D(sizes2D2[n3], sizes2D2[n3], (double[][])object2);
            object = new double[sizes2D2[n3]][sizes2D2[n3]];
            IOUtils.fillMatrix_2D(sizes2D2[n3], sizes2D2[n3], (double[][])object);
            doubleFFT_2D.realForward((double[][])object2);
            doubleFFT_2D.realInverse((double[][])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE((double[][])object2, (double[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D2[n3] + " x " + sizes2D2[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D2[n3] + " x " + sizes2D2[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (double[] input)...");
        for (n3 = 0; n3 < sizes2D.length; ++n3) {
            doubleFFT_2D = new DoubleFFT_2D(sizes2D[n3], sizes2D[n3]);
            d = 0.0;
            object2 = new double[2 * sizes2D[n3] * sizes2D[n3]];
            IOUtils.fillMatrix_2D(sizes2D[n3], sizes2D[n3], object2);
            object = new double[2 * sizes2D[n3] * sizes2D[n3]];
            for (n2 = 0; n2 < sizes2D[n3]; ++n2) {
                for (n = 0; n < sizes2D[n3]; ++n) {
                    object[n2 * 2 * AccuracyCheckDoubleFFT.sizes2D[n3] + 2 * n] = object2[n2 * sizes2D[n3] + n];
                }
            }
            doubleFFT_2D.realForwardFull((double[])object2);
            doubleFFT_2D.complexInverse((double[])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (double[][] input)...");
        for (n3 = 0; n3 < sizes2D.length; ++n3) {
            doubleFFT_2D = new DoubleFFT_2D(sizes2D[n3], sizes2D[n3]);
            d = 0.0;
            object2 = new double[sizes2D[n3]][2 * sizes2D[n3]];
            IOUtils.fillMatrix_2D(sizes2D[n3], sizes2D[n3], (double[][])object2);
            object = new double[sizes2D[n3]][2 * sizes2D[n3]];
            for (n2 = 0; n2 < sizes2D[n3]; ++n2) {
                for (n = 0; n < sizes2D[n3]; ++n) {
                    object[n2][2 * n] = object2[n2][n];
                }
            }
            doubleFFT_2D.realForwardFull((double[][])object2);
            doubleFFT_2D.complexInverse((double[][])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE((double[][])object2, (double[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (double[] input)...");
        for (n3 = 0; n3 < sizes2D.length; ++n3) {
            doubleFFT_2D = new DoubleFFT_2D(sizes2D[n3], sizes2D[n3]);
            d = 0.0;
            object2 = new double[2 * sizes2D[n3] * sizes2D[n3]];
            IOUtils.fillMatrix_2D(sizes2D[n3], sizes2D[n3], object2);
            object = new double[2 * sizes2D[n3] * sizes2D[n3]];
            for (n2 = 0; n2 < sizes2D[n3]; ++n2) {
                for (n = 0; n < sizes2D[n3]; ++n) {
                    object[n2 * 2 * AccuracyCheckDoubleFFT.sizes2D[n3] + 2 * n] = object2[n2 * sizes2D[n3] + n];
                }
            }
            doubleFFT_2D.realInverseFull((double[])object2, true);
            doubleFFT_2D.complexForward((double[])object2);
            d = AccuracyCheckDoubleFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (double[][] input)...");
        for (n3 = 0; n3 < sizes2D.length; ++n3) {
            doubleFFT_2D = new DoubleFFT_2D(sizes2D[n3], sizes2D[n3]);
            d = 0.0;
            object2 = new double[sizes2D[n3]][2 * sizes2D[n3]];
            IOUtils.fillMatrix_2D(sizes2D[n3], sizes2D[n3], (double[][])object2);
            object = new double[sizes2D[n3]][2 * sizes2D[n3]];
            for (n2 = 0; n2 < sizes2D[n3]; ++n2) {
                for (n = 0; n < sizes2D[n3]; ++n) {
                    object[n2][2 * n] = object2[n2][n];
                }
            }
            doubleFFT_2D.realInverseFull((double[][])object2, true);
            doubleFFT_2D.complexForward((double[][])object2);
            d = AccuracyCheckDoubleFFT.computeRMSE((double[][])object2, (double[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n3] + " x " + sizes2D[n3] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_3D() {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        double d;
        DoubleFFT_3D doubleFFT_3D;
        int n4;
        System.out.println("Checking accuracy of 3D real FFT (double[] input)...");
        for (n4 = 0; n4 < sizes3D2.length; ++n4) {
            doubleFFT_3D = new DoubleFFT_3D(sizes3D2[n4], sizes3D2[n4], sizes3D2[n4]);
            d = 0.0;
            object2 = new double[sizes3D2[n4] * sizes3D2[n4] * sizes3D2[n4]];
            IOUtils.fillMatrix_3D(sizes3D2[n4], sizes3D2[n4], sizes3D2[n4], object2);
            object = new double[sizes3D2[n4] * sizes3D2[n4] * sizes3D2[n4]];
            IOUtils.fillMatrix_3D(sizes3D2[n4], sizes3D2[n4], sizes3D2[n4], object);
            doubleFFT_3D.realForward((double[])object);
            doubleFFT_3D.realInverse((double[])object, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D2[n4] + " x " + sizes3D2[n4] + " x " + sizes3D2[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D2[n4] + " x " + sizes3D2[n4] + " x " + sizes3D2[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real FFT (double[][][] input)...");
        for (n4 = 0; n4 < sizes3D2.length; ++n4) {
            doubleFFT_3D = new DoubleFFT_3D(sizes3D2[n4], sizes3D2[n4], sizes3D2[n4]);
            d = 0.0;
            object2 = new double[sizes3D2[n4]][sizes3D2[n4]][sizes3D2[n4]];
            IOUtils.fillMatrix_3D(sizes3D2[n4], sizes3D2[n4], sizes3D2[n4], (double[][][])object2);
            object = new double[sizes3D2[n4]][sizes3D2[n4]][sizes3D2[n4]];
            IOUtils.fillMatrix_3D(sizes3D2[n4], sizes3D2[n4], sizes3D2[n4], (double[][][])object);
            doubleFFT_3D.realForward((double[][][])object);
            doubleFFT_3D.realInverse((double[][][])object, true);
            d = AccuracyCheckDoubleFFT.computeRMSE((double[][][])object2, (double[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D2[n4] + " x " + sizes3D2[n4] + " x " + sizes3D2[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D2[n4] + " x " + sizes3D2[n4] + " x " + sizes3D2[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (double[] input)...");
        for (n4 = 0; n4 < sizes3D.length; ++n4) {
            doubleFFT_3D = new DoubleFFT_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4]);
            d = 0.0;
            object2 = new double[2 * sizes3D[n4] * sizes3D[n4] * sizes3D[n4]];
            IOUtils.fillMatrix_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4], object2);
            object = new double[2 * sizes3D[n4] * sizes3D[n4] * sizes3D[n4]];
            for (n3 = 0; n3 < sizes3D[n4]; ++n3) {
                for (n2 = 0; n2 < sizes3D[n4]; ++n2) {
                    for (n = 0; n < sizes3D[n4]; ++n) {
                        object[n3 * 2 * AccuracyCheckDoubleFFT.sizes3D[n4] * AccuracyCheckDoubleFFT.sizes3D[n4] + n2 * 2 * AccuracyCheckDoubleFFT.sizes3D[n4] + 2 * n] = object2[n3 * sizes3D[n4] * sizes3D[n4] + n2 * sizes3D[n4] + n];
                    }
                }
            }
            doubleFFT_3D.realForwardFull((double[])object2);
            doubleFFT_3D.complexInverse((double[])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (double[][][] input)...");
        for (n4 = 0; n4 < sizes3D.length; ++n4) {
            doubleFFT_3D = new DoubleFFT_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4]);
            d = 0.0;
            object2 = new double[sizes3D[n4]][sizes3D[n4]][2 * sizes3D[n4]];
            IOUtils.fillMatrix_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4], (double[][][])object2);
            object = new double[sizes3D[n4]][sizes3D[n4]][2 * sizes3D[n4]];
            for (n3 = 0; n3 < sizes3D[n4]; ++n3) {
                for (n2 = 0; n2 < sizes3D[n4]; ++n2) {
                    for (n = 0; n < sizes3D[n4]; ++n) {
                        object[n3][n2][2 * n] = object2[n3][n2][n];
                    }
                }
            }
            doubleFFT_3D.realForwardFull((double[][][])object2);
            doubleFFT_3D.complexInverse((double[][][])object2, true);
            d = AccuracyCheckDoubleFFT.computeRMSE((double[][][])object2, (double[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (double[] input)...");
        for (n4 = 0; n4 < sizes3D.length; ++n4) {
            doubleFFT_3D = new DoubleFFT_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4]);
            d = 0.0;
            object2 = new double[2 * sizes3D[n4] * sizes3D[n4] * sizes3D[n4]];
            IOUtils.fillMatrix_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4], object2);
            object = new double[2 * sizes3D[n4] * sizes3D[n4] * sizes3D[n4]];
            for (n3 = 0; n3 < sizes3D[n4]; ++n3) {
                for (n2 = 0; n2 < sizes3D[n4]; ++n2) {
                    for (n = 0; n < sizes3D[n4]; ++n) {
                        object[n3 * 2 * AccuracyCheckDoubleFFT.sizes3D[n4] * AccuracyCheckDoubleFFT.sizes3D[n4] + n2 * 2 * AccuracyCheckDoubleFFT.sizes3D[n4] + 2 * n] = object2[n3 * sizes3D[n4] * sizes3D[n4] + n2 * sizes3D[n4] + n];
                    }
                }
            }
            doubleFFT_3D.realInverseFull((double[])object2, true);
            doubleFFT_3D.complexForward((double[])object2);
            d = AccuracyCheckDoubleFFT.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (double[][][] input)...");
        for (n4 = 0; n4 < sizes3D.length; ++n4) {
            doubleFFT_3D = new DoubleFFT_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4]);
            d = 0.0;
            object2 = new double[sizes3D[n4]][sizes3D[n4]][2 * sizes3D[n4]];
            IOUtils.fillMatrix_3D(sizes3D[n4], sizes3D[n4], sizes3D[n4], (double[][][])object2);
            object = new double[sizes3D[n4]][sizes3D[n4]][2 * sizes3D[n4]];
            for (n3 = 0; n3 < sizes3D[n4]; ++n3) {
                for (n2 = 0; n2 < sizes3D[n4]; ++n2) {
                    for (n = 0; n < sizes3D[n4]; ++n) {
                        object[n3][n2][2 * n] = object2[n3][n2][n];
                    }
                }
            }
            doubleFFT_3D.realInverseFull((double[][][])object2, true);
            doubleFFT_3D.complexForward((double[][][])object2);
            d = AccuracyCheckDoubleFFT.computeRMSE((double[][][])object2, (double[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n4] + " x " + sizes3D[n4] + " x " + sizes3D[n4] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
    }

    private static double computeRMSE(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)dArray.length);
    }

    private static double computeRMSE(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                double d2 = dArray[i][j] - dArray2[i][j];
                d += d2 * d2;
            }
        }
        return Math.sqrt(d / (double)(dArray.length * dArray[0].length));
    }

    private static double computeRMSE(double[][][] dArray, double[][][] dArray2) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length || dArray[0][0].length != dArray2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                for (int k = 0; k < dArray[0][0].length; ++k) {
                    double d2 = dArray[i][j][k] - dArray2[i][j][k];
                    d += d2 * d2;
                }
            }
        }
        return Math.sqrt(d / (double)(dArray.length * dArray[0].length * dArray[0][0].length));
    }

    public static void main(String[] stringArray) {
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_1D();
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_1D();
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_2D();
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_2D();
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_3D();
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_3D();
        System.exit(0);
    }
}

