/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.mathcs.jtransforms.fft.FloatingPointEqualityChecker;
import edu.emory.mathcs.jtransforms.fft.RealFFTUtils_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class RealFFTUtils_3DTest {
    public static final String DEFAULT_MESSAGE = "FFT of size %dx%dx%d: ";
    public static final int SEED = 20110628;
    private final int columns;
    private final DoubleFFT_3D fft3d;
    private final FloatFFT_3D fft3f;
    private final Random random;
    private final int rows;
    private final int slices;
    private final RealFFTUtils_3D unpacker;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        int[] nArray = new int[]{16, 32, 64};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    arrayList.add(new Object[]{nArray[i], nArray[j], nArray[k], 1, 20110628});
                    arrayList.add(new Object[]{nArray[i], nArray[j], nArray[k], 4, 20110628});
                }
            }
        }
        return arrayList;
    }

    public RealFFTUtils_3DTest(int n, int n2, int n3, int n4, long l) {
        this.slices = n;
        this.rows = n2;
        this.columns = n3;
        this.fft3d = new DoubleFFT_3D(n, n2, n3);
        this.fft3f = new FloatFFT_3D(n, n2, n3);
        this.random = new Random(l);
        this.unpacker = new RealFFTUtils_3D(n, n2, n3);
        ConcurrencyUtils.setNumberOfThreads(n4);
    }

    public FloatingPointEqualityChecker createEqualityChecker(double d, double d2) {
        String string = String.format(DEFAULT_MESSAGE, this.slices, this.rows, this.columns);
        return new FloatingPointEqualityChecker(string, d, d2, 0.0f, 0.0f);
    }

    public FloatingPointEqualityChecker createEqualityChecker(float f, float f2) {
        String string = String.format(DEFAULT_MESSAGE, this.slices, this.rows, this.columns);
        return new FloatingPointEqualityChecker(string, 0.0, 0.0, f, f2);
    }

    @Test
    public void testUnpack1dInput() {
        double d = 1.0E-8;
        double d2 = 0.005;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[] dArray = new double[this.slices * this.rows * this.columns];
        double[][][] dArray2 = new double[this.slices][this.rows][2 * this.columns];
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double d4;
                    dArray[(i * this.rows + j) * this.columns + k] = d4 = this.random.nextDouble();
                    dArray2[i][j][2 * k] = d4;
                    dArray2[i][j][2 * k + 1] = 0.0;
                }
            }
        }
        this.fft3d.complexForward(dArray2);
        this.fft3d.realForward(dArray);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < 2 * this.columns; ++k) {
                    String string = String.format("[%d][%d][%d]", i, j, k);
                    double d5 = dArray2[i][j][k];
                    double d6 = this.unpacker.unpack(i, j, k, dArray, 0);
                    floatingPointEqualityChecker.assertEquals(string, d5, d6);
                }
            }
        }
    }

    @Test
    public void testUnpack1fInput() {
        int n;
        float f = 0.1f;
        float f2 = 0.005f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[this.slices * this.rows * this.columns];
        float[][][] fArray2 = new float[this.slices][this.rows][2 * this.columns];
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (n = 0; n < this.columns; ++n) {
                    float f4;
                    fArray[(i * this.rows + j) * this.columns + n] = f4 = this.random.nextFloat();
                    fArray2[i][j][2 * n] = f4;
                    fArray2[i][j][2 * n + 1] = 0.0f;
                }
            }
        }
        this.fft3f.complexForward(fArray2);
        this.fft3f.realForward(fArray);
        for (n = 0; n < this.slices; ++n) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < 2 * this.columns; ++j) {
                    String string = String.format("[%d][%d][%d]", n, i, j);
                    float f5 = fArray2[n][i][j];
                    float f6 = this.unpacker.unpack(n, i, j, fArray, 0);
                    floatingPointEqualityChecker.assertEquals(string, f5, f6);
                }
            }
        }
    }

    @Test
    public void testUnpack3dInput() {
        double d = 1.0E-8;
        double d2 = 0.005;
        double d3 = d * d2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(d, d3);
        double[][][] dArray = new double[this.slices][this.rows][this.columns];
        double[][][] dArray2 = new double[this.slices][this.rows][2 * this.columns];
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double d4;
                    dArray[i][j][k] = d4 = this.random.nextDouble();
                    dArray2[i][j][2 * k] = d4;
                    dArray2[i][j][2 * k + 1] = 0.0;
                }
            }
        }
        this.fft3d.complexForward(dArray2);
        this.fft3d.realForward(dArray);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < 2 * this.columns; ++k) {
                    String string = String.format("[%d][%d][%d]", i, j, k);
                    double d5 = dArray2[i][j][k];
                    double d6 = this.unpacker.unpack(i, j, k, dArray);
                    floatingPointEqualityChecker.assertEquals(string, d5, d6);
                }
            }
        }
    }

    @Test
    public void testUnpack3fInput() {
        int n;
        float f = 0.1f;
        float f2 = 0.005f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[][][] fArray = new float[this.slices][this.rows][this.columns];
        float[][][] fArray2 = new float[this.slices][this.rows][2 * this.columns];
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (n = 0; n < this.columns; ++n) {
                    float f4;
                    fArray[i][j][n] = f4 = this.random.nextFloat();
                    fArray2[i][j][2 * n] = f4;
                    fArray2[i][j][2 * n + 1] = 0.0f;
                }
            }
        }
        this.fft3f.complexForward(fArray2);
        this.fft3f.realForward(fArray);
        for (n = 0; n < this.slices; ++n) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < 2 * this.columns; ++j) {
                    String string = String.format("[%d][%d][%d]", n, i, j);
                    float f5 = fArray2[n][i][j];
                    float f6 = this.unpacker.unpack(n, i, j, fArray);
                    floatingPointEqualityChecker.assertEquals(string, f5, f6);
                }
            }
        }
    }

    @Test
    public void testPack1dInput() {
        double[] dArray = new double[this.slices * this.rows * this.columns];
        String string = String.format(DEFAULT_MESSAGE, this.slices, this.rows, this.columns) + "[%d][%d][%d]";
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < 2 * this.columns; ++k) {
                    double d = this.random.nextDouble();
                    try {
                        this.unpacker.pack(d, i, j, k, dArray, 0);
                        double d2 = this.unpacker.unpack(i, j, k, dArray, 0);
                        Assert.assertEquals((String)String.format(string, i, j, k), (double)d, (double)d2, (double)0.0);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Test
    public void testPack3dInput() {
        double[][][] dArray = new double[this.slices][this.rows][this.columns];
        String string = String.format(DEFAULT_MESSAGE, this.slices, this.rows, this.columns) + "[%d][%d][%d]";
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < 2 * this.columns; ++k) {
                    double d = this.random.nextDouble();
                    try {
                        this.unpacker.pack(d, i, j, k, dArray);
                        double d2 = this.unpacker.unpack(i, j, k, dArray);
                        Assert.assertEquals((String)String.format(string, i, j, k), (double)d, (double)d2, (double)0.0);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Test
    public void testPack1fInput() {
        float[] fArray = new float[this.slices * this.rows * this.columns];
        String string = String.format(DEFAULT_MESSAGE, this.slices, this.rows, this.columns) + "[%d][%d][%d]";
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < 2 * this.columns; ++k) {
                    float f = this.random.nextFloat();
                    try {
                        this.unpacker.pack(f, i, j, k, fArray, 0);
                        float f2 = this.unpacker.unpack(i, j, k, fArray, 0);
                        Assert.assertEquals((String)String.format(string, i, j, k), (double)f, (double)f2, (double)0.0);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Test
    public void testPack3fInput() {
        float[][][] fArray = new float[this.slices][this.rows][this.columns];
        String string = String.format(DEFAULT_MESSAGE, this.slices, this.rows, this.columns) + "[%d][%d][%d]";
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < 2 * this.columns; ++k) {
                    float f = this.random.nextFloat();
                    try {
                        this.unpacker.pack(f, i, j, k, fArray);
                        float f2 = this.unpacker.unpack(i, j, k, fArray);
                        Assert.assertEquals((String)String.format(string, i, j, k), (double)f, (double)f2, (double)0.0);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

